package com.ruoyi.project.zjsgfa.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.zjsgfa.mapper.SjSggyGjsbxnyqMapper;
import com.ruoyi.project.zjsgfa.domain.SjSggyGjsbxnyq;
import com.ruoyi.project.zjsgfa.service.ISjSggyGjsbxnyqService;

/**
 * 设计-施工概要-关键设备性能要求Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-08-18
 */
@Service
public class SjSggyGjsbxnyqServiceImpl implements ISjSggyGjsbxnyqService 
{
    @Autowired
    private SjSggyGjsbxnyqMapper sjSggyGjsbxnyqMapper;

    /**
     * 查询设计-施工概要-关键设备性能要求
     * 
     * @param id 设计-施工概要-关键设备性能要求主键
     * @return 设计-施工概要-关键设备性能要求
     */
    @Override
    public SjSggyGjsbxnyq selectSjSggyGjsbxnyqById(Long id)
    {
        return sjSggyGjsbxnyqMapper.selectSjSggyGjsbxnyqById(id);
    }

    /**
     * 查询设计-施工概要-关键设备性能要求列表
     * 
     * @param sjSggyGjsbxnyq 设计-施工概要-关键设备性能要求
     * @return 设计-施工概要-关键设备性能要求
     */
    @Override
    public List<SjSggyGjsbxnyq> selectSjSggyGjsbxnyqList(SjSggyGjsbxnyq sjSggyGjsbxnyq)
    {
        return sjSggyGjsbxnyqMapper.selectSjSggyGjsbxnyqList(sjSggyGjsbxnyq);
    }

    /**
     * 新增设计-施工概要-关键设备性能要求
     * 
     * @param sjSggyGjsbxnyq 设计-施工概要-关键设备性能要求
     * @return 结果
     */
    @Override
    public int insertSjSggyGjsbxnyq(SjSggyGjsbxnyq sjSggyGjsbxnyq)
    {
        return sjSggyGjsbxnyqMapper.insertSjSggyGjsbxnyq(sjSggyGjsbxnyq);
    }

    /**
     * 修改设计-施工概要-关键设备性能要求
     * 
     * @param sjSggyGjsbxnyq 设计-施工概要-关键设备性能要求
     * @return 结果
     */
    @Override
    public int updateSjSggyGjsbxnyq(SjSggyGjsbxnyq sjSggyGjsbxnyq)
    {
        return sjSggyGjsbxnyqMapper.updateSjSggyGjsbxnyq(sjSggyGjsbxnyq);
    }

    /**
     * 批量删除设计-施工概要-关键设备性能要求
     * 
     * @param ids 需要删除的设计-施工概要-关键设备性能要求主键
     * @return 结果
     */
    @Override
    public int deleteSjSggyGjsbxnyqByIds(Long[] ids)
    {
        return sjSggyGjsbxnyqMapper.deleteSjSggyGjsbxnyqByIds(ids);
    }

    /**
     * 删除设计-施工概要-关键设备性能要求信息
     * 
     * @param id 设计-施工概要-关键设备性能要求主键
     * @return 结果
     */
    @Override
    public int deleteSjSggyGjsbxnyqById(Long id)
    {
        return sjSggyGjsbxnyqMapper.deleteSjSggyGjsbxnyqById(id);
    }
}
