package com.ruoyi.project.zjsgfa.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.zjsgfa.mapper.SjLjsmMapper;
import com.ruoyi.project.zjsgfa.domain.SjLjsm;
import com.ruoyi.project.zjsgfa.service.ISjLjsmService;

/**
 * 设计信息-邻井扫描Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-07-22
 */
@Service
public class SjLjsmServiceImpl implements ISjLjsmService 
{
    @Autowired
    private SjLjsmMapper sjLjsmMapper;

    /**
     * 查询设计信息-邻井扫描
     * 
     * @param id 设计信息-邻井扫描主键
     * @return 设计信息-邻井扫描
     */
    @Override
    public SjLjsm selectSjLjsmById(Long id)
    {
        return sjLjsmMapper.selectSjLjsmById(id);
    }

    /**
     * 查询设计信息-邻井扫描列表
     * 
     * @param sjLjsm 设计信息-邻井扫描
     * @return 设计信息-邻井扫描
     */
    @Override
    public List<SjLjsm> selectSjLjsmList(SjLjsm sjLjsm)
    {
        return sjLjsmMapper.selectSjLjsmList(sjLjsm);
    }

    /**
     * 新增设计信息-邻井扫描
     * 
     * @param sjLjsm 设计信息-邻井扫描
     * @return 结果
     */
    @Override
    public int insertSjLjsm(SjLjsm sjLjsm)
    {
        return sjLjsmMapper.insertSjLjsm(sjLjsm);
    }

    /**
     * 修改设计信息-邻井扫描
     * 
     * @param sjLjsm 设计信息-邻井扫描
     * @return 结果
     */
    @Override
    public int updateSjLjsm(SjLjsm sjLjsm)
    {
        sjLjsm.setUpdateTime(DateUtils.getNowDate());
        return sjLjsmMapper.updateSjLjsm(sjLjsm);
    }

    /**
     * 批量删除设计信息-邻井扫描
     * 
     * @param ids 需要删除的设计信息-邻井扫描主键
     * @return 结果
     */
    @Override
    public int deleteSjLjsmByIds(Long[] ids)
    {
        return sjLjsmMapper.deleteSjLjsmByIds(ids);
    }

    /**
     * 删除设计信息-邻井扫描信息
     * 
     * @param id 设计信息-邻井扫描主键
     * @return 结果
     */
    @Override
    public int deleteSjLjsmById(Long id)
    {
        return sjLjsmMapper.deleteSjLjsmById(id);
    }
}
