package com.ruoyi.project.zjsgfa.service.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.bean.BeanUtils;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.framework.web.domain.BaseEntity;
import com.ruoyi.project.zjsgfa.domain.*;
import com.ruoyi.project.zjsgfa.mapper.*;
import com.ruoyi.project.zt.domain.*;
import com.ruoyi.project.zt.domain.vo.SjInfo;
import com.ruoyi.project.zt.service.DjdcService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.zjsgfa.service.ISjDjjcService;

/**
 * 设计信息-井基础信息Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-06-23
 */
@Service
public class SjDjjcServiceImpl implements ISjDjjcService 
{
    @Autowired
    private SjDjjcMapper sjDjjcMapper;

    @Autowired
    private DjdcService djdcService;
    @Autowired
    private SjLjjwMapper sjLjjwMapper;

    @Autowired
    private SjZqfxMapper sjZqfxMapper;
    @Autowired
    private SjZtgjsjMapper sjZtgjsjMapper;
    @Autowired
    private SjQkztfxMapper sjQkztfxMapper;
    @Autowired
    private SjJsjgMapper sjJsjgMapper;
    @Autowired
    private SjSzfxjgMapper sjSzfxjgMapper;

    @Autowired
    private SjLjtjztMapper sjLjtjztMapper;

    @Autowired
    private SjZtxxMapper sjZtxxMapper;


    /**
     * 查询设计信息-井基础信息
     * 
     * @param id 设计信息-井基础信息主键
     * @return 设计信息-井基础信息
     */
    @Override
    public SjDjjc selectSjDjjcById(Long id)
    {
        return sjDjjcMapper.selectSjDjjcById(id);
    }

    /**
     * 查询设计信息-井基础信息列表
     * 
     * @param sjDjjc 设计信息-井基础信息
     * @return 设计信息-井基础信息
     */
    @Override
    public List<SjDjjc> selectSjDjjcList(SjDjjc sjDjjc)
    {
        return sjDjjcMapper.selectSjDjjcList(sjDjjc);
    }

    /**
     * 新增设计信息-井基础信息
     * 
     * @param sjDjjc 设计信息-井基础信息
     * @return 结果
     */
    @Override
    public int insertSjDjjc(SjDjjc sjDjjc)
    {
        SjDjjc sjDjjc1 =sjDjjcMapper.selectSjDjjcByJh(sjDjjc.getJh());
        if(sjDjjc1!=null){
            return 3;
        }

        sjDjjc.setCreatedBy(SecurityUtils.getUsername());
        return sjDjjcMapper.insertSjDjjc(sjDjjc);
    }

    /**
     * 修改设计信息-井基础信息
     * 
     * @param sjDjjc 设计信息-井基础信息
     * @return 结果
     */
    @Override
    public int updateSjDjjc(SjDjjc sjDjjc)
    {
        sjDjjc.setUpdateTime(DateUtils.getNowDate());
        sjDjjc.setUpdateBy(SecurityUtils.getUsername());
        return sjDjjcMapper.updateSjDjjc(sjDjjc);
    }

    /**
     * 批量删除设计信息-井基础信息
     * 
     * @param ids 需要删除的设计信息-井基础信息主键
     * @return 结果
     */
    @Override
    public int deleteSjDjjcByIds(Long[] ids)
    {
        return sjDjjcMapper.deleteSjDjjcByIds(ids);
    }

    /**
     * 删除设计信息-井基础信息信息
     * 
     * @param id 设计信息-井基础信息主键
     * @return 结果
     */
    @Override
    public int deleteSjDjjcById(Long id)
    {
        return sjDjjcMapper.deleteSjDjjcById(id);
    }

    @Override
    public AjaxResult saveLjzl(CommonParam param) throws Exception {
        String jh = param.getSjjh();
        String ljjh = param.getJh();
        SjDjjc sjDjjc = sjDjjcMapper.selectSjDjjcByJh(jh);
        param.setQk(sjDjjc.getQk());
        param.setJkhzb(sjDjjc.getJkhzb());
        param.setJkzzb(sjDjjc.getJkzzb());
        param.setJdhzb(sjDjjc.getJdhzb());
        param.setJdzzb(sjDjjc.getJdzzb());
        param.setJh(null);

        //保存邻井
//        List<Ljjw> ljjwList = djdcService.getLjjwList(param);
//        List<SjLjjw> sjLjjwList=new ArrayList<>();
//        ljjwList.forEach(item->{
//            SjLjjw sjLjjw=new SjLjjw();
//            BeanUtils.copyProperties(item,sjLjjw);
//            sjLjjw.setJh(jh);
//            sjLjjw.setLjjh(item.getJh());
//            sjLjjwList.add(sjLjjw);
//        });
//        if(sjLjjwList.size()>0){
//            sjLjjwMapper.deleteSjLjjwByJh(jh);
//            sjLjjwMapper.insertSjLjjwBatch(sjLjjwList);
//
//        }
        param.setJkhzb(null);
        param.setJkzzb(null);
        param.setJdhzb(null);
        param.setJdzzb(null);
        param.setJh(ljjh);
        //周期分析
        List<DjZqsjfx> zqshfxList = djdcService.getZqshfxList(param);
        List<SjZqfx> sjZqfxList=new ArrayList<>();
        zqshfxList.forEach(item->{
            SjZqfx sjZqfx=new SjZqfx();
            BeanUtils.copyProperties(item,sjZqfx);
            sjZqfx.setJh(jh);
            sjZqfx.setLjjh(item.getJh());
            sjZqfx.setCw(item.getCw());
            sjZqfx.setZjzq(item.getZjzq());
            sjZqfx.setZjycsl(item.getZjycsl());
            sjZqfx.setZjsczq(item.getZjsczq());
            sjZqfx.setZjsl(item.getZjsl());
            sjZqfx.setZwzq(item.getZwzq());
            sjZqfx.setWjycsl(item.getWjycsl());
            sjZqfx.setWjsczq(item.getWjsczq());
            sjZqfx.setZjycms(item.getZjycms());
            sjZqfx.setWjycms(item.getWjycms());
            sjZqfxList.add(sjZqfx);
        });
        if(sjZqfxList.size()>0){
            sjZqfxMapper.deleteSjZqfxByJh(jh);
            sjZqfxMapper.insertSjZqfxBatch(sjZqfxList);
        }
        //钻头关键数据
        List<Djjc> djjcList = djdcService.getDjjcList(param);
        List<SjZtgjsj> sjZtgjsjList=new ArrayList<>();

        djjcList.forEach(item->{
            SjZtgjsj sjZtgjsj=new SjZtgjsj();
            BeanUtils.copyProperties(item,sjZtgjsj);
            sjZtgjsj.setJh(jh);
            sjZtgjsj.setLjjh(item.getJh());
            sjZtgjsjList.add(sjZtgjsj);
        });
        if(sjZtgjsjList.size()>0){
            sjZtgjsjMapper.deleteSjZtgjsjByJh(jh);
            sjZtgjsjMapper.insertSjZtgjsjBatch(sjZtgjsjList);
        }
        //区块钻头分析
        List<DjZtfx> djZtfxList = djdcService.getDjZtfxList(param);
        List<SjQkztfx> sjQkztfxList=new ArrayList<>();
        djZtfxList.forEach(item->{
            SjQkztfx sjQkztfx=new SjQkztfx();
            BeanUtils.copyProperties(item,sjQkztfx);
            sjQkztfx.setJh(jh);
            sjQkztfxList.add(sjQkztfx);
        });
        if(sjQkztfxList.size()>0){
            sjQkztfxMapper.deleteSjQkztfxByJh(jh);
            sjQkztfxMapper.insertSjQkztfxBatch(sjQkztfxList);
        }

        //实钻分析结果
        SjJsjg sjJsjg =new SjJsjg();
        sjJsjg.setJh(jh);
        List<SjJsjg> sjJsjgList = sjJsjgMapper.selectSjJsjgList(sjJsjg);
        List<SjInfo> sjInfoList=new ArrayList<>();
        for(int i=0;i<sjJsjgList.size();i++){
            SjInfo sjInfo =new SjInfo();
            sjInfo.setKc((i+1)+"");
            sjInfo.setZtcc(sjJsjgList.get(i).getZtzj());
            sjInfoList.add(sjInfo);
        }
        param.setSj(sjInfoList);
        List<LjSzfxjg> ljSzfxjgList=djdcService.getSztfxjgList(djZtfxList,djjcList,param);
        List<SjSzfxjg> sjSzfxjgList=new ArrayList<>();
        ljSzfxjgList.forEach(item->{
            SjSzfxjg sjSzfxjg=new SjSzfxjg();
            BeanUtils.copyProperties(item,sjSzfxjg);
            sjSzfxjg.setJh(jh);
            sjSzfxjgList.add(sjSzfxjg);
        });
        if(sjSzfxjgList.size()>0){
            sjSzfxjgMapper.deleteSjSzfxjgByJh(jh);
            sjSzfxjgMapper.insertSjSzfxjgBatch(sjSzfxjgList);
        }
        return AjaxResult.success();
    }

    @Override
    public AjaxResult saveZtxh(CommonParam param) {
        String jh = param.getSjjh();
        SjZtgjsj sjZtgjsj = new SjZtgjsj();
        sjZtgjsj.setJh(jh);
        List<SjZtgjsj> sjZtgjsjList = sjZtgjsjMapper.selectSjZtgjsjList(sjZtgjsj);
        SjJsjg sjJsjg = new SjJsjg();
        sjJsjg.setJh(jh);
        List<SjJsjg> sjJsjgList = sjJsjgMapper.selectSjJsjgList(sjJsjg);
        List<SjLjtjzt> sjLjtjztList=new ArrayList<>();
        for(int i=0;i<sjJsjgList.size();i++){
            SjJsjg sjJsjg1 = sjJsjgList.get(i);
            final int kc=i+1;
            //查询钻头关键数据
            List<SjZtgjsj> collect = sjZtgjsjList.stream().filter(it -> it.getKc().equals(kc + "")).collect(Collectors.toList()).stream().sorted(Comparator.comparing(SjZtgjsj::getJxzs)).collect(Collectors.toList());
            if(collect.size()>3){
                collect=collect.subList(0,3);
            }
            SjZtxx sjZtxx =new SjZtxx();
            collect.forEach(it->{
                SjLjtjzt sjLjtjzt=new SjLjtjzt();
                sjLjtjzt.setJh(jh);
                sjLjtjzt.setLjjh(it.getLjjh());
                sjLjtjzt.setKc(sjJsjg1.getKc());
                sjLjtjzt.setCc(it.getZtcc());
                sjLjtjzt.setZtxh(it.getZtxh());
                sjLjtjzt.setSy(it.getPz());
                sjLjtjzt.setZjjd(it.getJd());
                sjLjtjzt.setCw(it.getCw());
                sjLjtjzt.setJxzs(it.getJxzs());
                sjLjtjztList.add(sjLjtjzt);
            });
            if(collect.size()>0){
                sjZtxx.setJh(jh);
                sjZtxx.setLb("邻井推荐");
                sjZtxx.setKc(sjJsjg1.getKc());
                sjZtxx.setZtxh(collect.get(0).getZtxh());
                sjZtxxMapper.insertSjZtxx(sjZtxx);
            }
        }
        if(sjLjtjztList.size()>0){
            sjLjtjztMapper.insertSjLjtjztBatch(sjLjtjztList);
        }

        return AjaxResult.success("计算成功");
    }


}
