package com.ruoyi.project.zjsgfa.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 设计-地层分析—地质分层对象 sj_dcfx_dzfc
 * 
 * @author ruoyi
 * @date 2025-07-28
 */
public class SjDcfxDzfc extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 地质分层 */
    @Excel(name = "地质分层")
    private String dzfc;

    /** 垂深 */
    @Excel(name = "垂深")
    private Double cs;

    /** 井身 */
    @Excel(name = "井身")
    private Double xs;

    /** 岩性提示 */
    @Excel(name = "岩性提示")
    private String yxts;

    /** 油气水提示 */
    @Excel(name = "油气水提示")
    private String yqsts;

    /** 故障提示 */
    @Excel(name = "故障提示")
    private String gzts;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setJh(String jh) 
    {
        this.jh = jh;
    }

    public String getJh() 
    {
        return jh;
    }

    public void setDzfc(String dzfc) 
    {
        this.dzfc = dzfc;
    }

    public String getDzfc() 
    {
        return dzfc;
    }

    public void setCs(Double cs) 
    {
        this.cs = cs;
    }

    public Double getCs() 
    {
        return cs;
    }

    public void setXs(Double xs) 
    {
        this.xs = xs;
    }

    public Double getXs() 
    {
        return xs;
    }

    public void setYxts(String yxts) 
    {
        this.yxts = yxts;
    }

    public String getYxts() 
    {
        return yxts;
    }

    public void setYqsts(String yqsts) 
    {
        this.yqsts = yqsts;
    }

    public String getYqsts() 
    {
        return yqsts;
    }

    public void setGzts(String gzts) 
    {
        this.gzts = gzts;
    }

    public String getGzts() 
    {
        return gzts;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("jh", getJh())
            .append("dzfc", getDzfc())
            .append("cs", getCs())
            .append("xs", getXs())
            .append("yxts", getYxts())
            .append("yqsts", getYqsts())
            .append("gzts", getGzts())
            .toString();
    }
}
