package com.zjsgfa.project.zjsgfa.service.impl;

import java.nio.charset.StandardCharsets;
import java.util.List;

import cn.hutool.core.codec.Base64;
import com.zjsgfa.common.utils.DateUtils;
import com.zjsgfa.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SgfambKcSggyMapper;
import com.zjsgfa.project.zjsgfa.domain.SgfambKcSggy;
import com.zjsgfa.project.zjsgfa.service.ISgfambKcSggyService;

/**
 * 施工方案模板管理—开次-施工概要Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-09-23
 */
@Service
public class SgfambKcSggyServiceImpl implements ISgfambKcSggyService 
{
    @Autowired
    private SgfambKcSggyMapper sgfambKcSggyMapper;

    /**
     * 查询施工方案模板管理—开次-施工概要
     * 
     * @param id 施工方案模板管理—开次-施工概要主键
     * @return 施工方案模板管理—开次-施工概要
     */
    @Override
    public SgfambKcSggy selectSgfambKcSggyById(Long id)
    {
        SgfambKcSggy sgfambKcSggy = sgfambKcSggyMapper.selectSgfambKcSggyById(id);
        return sgfambKcSggy;
    }

    /**
     * 查询施工方案模板管理—开次-施工概要列表
     * 
     * @param sgfambKcSggy 施工方案模板管理—开次-施工概要
     * @return 施工方案模板管理—开次-施工概要
     */
    @Override
    public List<SgfambKcSggy> selectSgfambKcSggyList(SgfambKcSggy sgfambKcSggy)
    {
        return sgfambKcSggyMapper.selectSgfambKcSggyList(sgfambKcSggy);
    }

    /**
     * 新增施工方案模板管理—开次-施工概要
     * 
     * @param sgfambKcSggy 施工方案模板管理—开次-施工概要
     * @return 结果
     */
    @Override
    public int insertSgfambKcSggy(SgfambKcSggy sgfambKcSggy)
    {

        if(StringUtils.isNotEmpty(sgfambKcSggy.getZjgccs())){
            sgfambKcSggy.setZjgccs(new String(Base64.decode(sgfambKcSggy.getZjgccs()), StandardCharsets.UTF_8));
        }

        if(StringUtils.isNotEmpty(sgfambKcSggy.getGjfx())){
            sgfambKcSggy.setGjfx(new String(Base64.decode(sgfambKcSggy.getGjfx()), StandardCharsets.UTF_8));
        }

        if(StringUtils.isNotEmpty(sgfambKcSggy.getGjyh())){
            sgfambKcSggy.setGjyh(new String(Base64.decode(sgfambKcSggy.getGjyh()), StandardCharsets.UTF_8));
        }

        if(StringUtils.isNotEmpty(sgfambKcSggy.getZjycs())){
            sgfambKcSggy.setZjycs(new String(Base64.decode(sgfambKcSggy.getZjycs()), StandardCharsets.UTF_8));
        }
        int i = sgfambKcSggyMapper.insertSgfambKcSggy(sgfambKcSggy);
        return i;
    }

    /**
     * 修改施工方案模板管理—开次-施工概要
     * 
     * @param sgfambKcSggy 施工方案模板管理—开次-施工概要
     * @return 结果
     */
    @Override
    public int updateSgfambKcSggy(SgfambKcSggy sgfambKcSggy)
    {
        if(StringUtils.isNotEmpty(sgfambKcSggy.getZjgccs())){
            sgfambKcSggy.setZjgccs(new String(Base64.decode(sgfambKcSggy.getZjgccs()), StandardCharsets.UTF_8));
        }

        if(StringUtils.isNotEmpty(sgfambKcSggy.getGjfx())){
            sgfambKcSggy.setGjfx(new String(Base64.decode(sgfambKcSggy.getGjfx()), StandardCharsets.UTF_8));
        }

        if(StringUtils.isNotEmpty(sgfambKcSggy.getGjyh())){
            sgfambKcSggy.setGjyh(new String(Base64.decode(sgfambKcSggy.getGjyh()), StandardCharsets.UTF_8));
        }

        if(StringUtils.isNotEmpty(sgfambKcSggy.getZjycs())){
            sgfambKcSggy.setZjycs(new String(Base64.decode(sgfambKcSggy.getZjycs()), StandardCharsets.UTF_8));
        }
        sgfambKcSggy.setUpdateTime(DateUtils.getNowDate());
        return sgfambKcSggyMapper.updateSgfambKcSggy(sgfambKcSggy);
    }

    /**
     * 批量删除施工方案模板管理—开次-施工概要
     * 
     * @param ids 需要删除的施工方案模板管理—开次-施工概要主键
     * @return 结果
     */
    @Override
    public int deleteSgfambKcSggyByIds(Long[] ids)
    {
        return sgfambKcSggyMapper.deleteSgfambKcSggyByIds(ids);
    }

    /**
     * 删除施工方案模板管理—开次-施工概要信息
     * 
     * @param id 施工方案模板管理—开次-施工概要主键
     * @return 结果
     */
    @Override
    public int deleteSgfambKcSggyById(Long id)
    {
        return sgfambKcSggyMapper.deleteSgfambKcSggyById(id);
    }
}
