package com.zjsgfa.project.zjsgfa.mapper;

import java.util.List;
import com.zjsgfa.project.zjsgfa.domain.Sgfamb;
import com.zjsgfa.project.zjsgfa.domain.SgfambKcxx;

/**
 * 施工方案模板管理Mapper接口
 * 
 * @author ruoyi
 * @date 2025-09-23
 */
public interface SgfambMapper 
{
    /**
     * 查询施工方案模板管理
     * 
     * @param id 施工方案模板管理主键
     * @return 施工方案模板管理
     */
    public Sgfamb selectSgfambById(Long id);

    /**
     * 查询施工方案模板管理列表
     * 
     * @param sgfamb 施工方案模板管理
     * @return 施工方案模板管理集合
     */
    public List<Sgfamb> selectSgfambList(Sgfamb sgfamb);

    /**
     * 新增施工方案模板管理
     * 
     * @param sgfamb 施工方案模板管理
     * @return 结果
     */
    public int insertSgfamb(Sgfamb sgfamb);

    /**
     * 修改施工方案模板管理
     * 
     * @param sgfamb 施工方案模板管理
     * @return 结果
     */
    public int updateSgfamb(Sgfamb sgfamb);

    /**
     * 删除施工方案模板管理
     * 
     * @param id 施工方案模板管理主键
     * @return 结果
     */
    public int deleteSgfambById(Long id);

    /**
     * 批量删除施工方案模板管理
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSgfambByIds(Long[] ids);

    /**
     * 批量删除施工方案模板管理—开次信息
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSgfambKcxxByZbids(Long[] ids);
    
    /**
     * 批量新增施工方案模板管理—开次信息
     * 
     * @param sgfambKcxxList 施工方案模板管理—开次信息列表
     * @return 结果
     */
    public int batchSgfambKcxx(List<SgfambKcxx> sgfambKcxxList);
    

    /**
     * 通过施工方案模板管理主键删除施工方案模板管理—开次信息信息
     * 
     * @param id 施工方案模板管理ID
     * @return 结果
     */
    public int deleteSgfambKcxxByZbid(Long id);
}
