package com.zjsgfa.project.zjsgfa.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SgfambKcSggy;
import com.zjsgfa.project.zjsgfa.service.ISgfambKcSggyService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 施工方案模板管理—开次-施工概要Controller
 * 
 * @author ruoyi
 * @date 2025-09-23
 */
@RestController
@RequestMapping("/system/sgfambKcSggy")
public class SgfambKcSggyController extends BaseController
{
    @Autowired
    private ISgfambKcSggyService sgfambKcSggyService;

    /**
     * 查询施工方案模板管理—开次-施工概要列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sgfambKcSggy:list')")
    @GetMapping("/list")
    public TableDataInfo list(SgfambKcSggy sgfambKcSggy)
    {
        startPage();
        List<SgfambKcSggy> list = sgfambKcSggyService.selectSgfambKcSggyList(sgfambKcSggy);
        return getDataTable(list);
    }

    /**
     * 导出施工方案模板管理—开次-施工概要列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sgfambKcSggy:export')")
    @Log(title = "施工方案模板管理—开次-施工概要", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SgfambKcSggy sgfambKcSggy)
    {
        List<SgfambKcSggy> list = sgfambKcSggyService.selectSgfambKcSggyList(sgfambKcSggy);
        ExcelUtil<SgfambKcSggy> util = new ExcelUtil<SgfambKcSggy>(SgfambKcSggy.class);
        util.exportExcel(response, list, "施工方案模板管理—开次-施工概要数据");
    }

    /**
     * 获取施工方案模板管理—开次-施工概要详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sgfambKcSggy:query')")
    @GetMapping(value = "/{id}")
    public Map<String, Object> getInfo(@PathVariable("id") Long id)
    {
        SgfambKcSggy sgfambKcSggy = sgfambKcSggyService.selectSgfambKcSggyById(id);
        Map<String, Object> map =new HashMap<>();
        map.put("data",sgfambKcSggy);
        return map;
    }

    /**
     * 新增施工方案模板管理—开次-施工概要
     */
    //@PreAuthorize("@ss.hasPermi('system:sgfambKcSggy:add')")
    @Log(title = "施工方案模板管理—开次-施工概要", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SgfambKcSggy sgfambKcSggy)
    {
        return toAjax(sgfambKcSggyService.insertSgfambKcSggy(sgfambKcSggy));
    }

    /**
     * 修改施工方案模板管理—开次-施工概要
     */
    //@PreAuthorize("@ss.hasPermi('system:sgfambKcSggy:edit')")
    @Log(title = "施工方案模板管理—开次-施工概要", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SgfambKcSggy sgfambKcSggy)
    {
        return toAjax(sgfambKcSggyService.updateSgfambKcSggy(sgfambKcSggy));
    }

    /**
     * 删除施工方案模板管理—开次-施工概要
     */
    //@PreAuthorize("@ss.hasPermi('system:sgfambKcSggy:remove')")
    @Log(title = "施工方案模板管理—开次-施工概要", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sgfambKcSggyService.deleteSgfambKcSggyByIds(ids));
    }
}
