package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import com.zjsgfa.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjJhzqMapper;
import com.zjsgfa.project.zjsgfa.domain.SjJhzq;
import com.zjsgfa.project.zjsgfa.service.ISjJhzqService;

/**
 * 设计-计划周期Service业务层处理
 * 
 * @author
 * @date 2025-07-24
 */
@Service
public class SjJhzqServiceImpl implements ISjJhzqService 
{
    @Autowired
    private SjJhzqMapper sjJhzqMapper;

    /**
     * 查询设计-计划周期
     * 
     * @param id 设计-计划周期主键
     * @return 设计-计划周期
     */
    @Override
    public SjJhzq selectSjJhzqById(Long id)
    {
        return sjJhzqMapper.selectSjJhzqById(id);
    }

    /**
     * 查询设计-计划周期列表
     * 
     * @param sjJhzq 设计-计划周期
     * @return 设计-计划周期
     */
    @Override
    public List<SjJhzq> selectSjJhzqList(SjJhzq sjJhzq)
    {
        return sjJhzqMapper.selectSjJhzqList(sjJhzq);
    }

    /**
     * 新增设计-计划周期
     * 
     * @param sjJhzq 设计-计划周期
     * @return 结果
     */
    @Override
    public int insertSjJhzq(SjJhzq sjJhzq)
    {
        return sjJhzqMapper.insertSjJhzq(sjJhzq);
    }

    /**
     * 修改设计-计划周期
     * 
     * @param sjJhzq 设计-计划周期
     * @return 结果
     */
    @Override
    public int updateSjJhzq(SjJhzq sjJhzq)
    {
        sjJhzq.setUpdateTime(DateUtils.getNowDate());
        return sjJhzqMapper.updateSjJhzq(sjJhzq);
    }

    /**
     * 批量删除设计-计划周期
     * 
     * @param ids 需要删除的设计-计划周期主键
     * @return 结果
     */
    @Override
    public int deleteSjJhzqByIds(Long[] ids)
    {
        return sjJhzqMapper.deleteSjJhzqByIds(ids);
    }

    /**
     * 删除设计-计划周期信息
     * 
     * @param id 设计-计划周期主键
     * @return 结果
     */
    @Override
    public int deleteSjJhzqById(Long id)
    {
        return sjJhzqMapper.deleteSjJhzqById(id);
    }
}
