package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import com.zjsgfa.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.ClYxsjMapper;
import com.zjsgfa.project.zjsgfa.domain.ClYxsj;
import com.zjsgfa.project.zjsgfa.service.IClYxsjService;

/**
 * 常量-岩性数据Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-09-22
 */
@Service
public class ClYxsjServiceImpl implements IClYxsjService 
{
    @Autowired
    private ClYxsjMapper clYxsjMapper;

    /**
     * 查询常量-岩性数据
     * 
     * @param id 常量-岩性数据主键
     * @return 常量-岩性数据
     */
    @Override
    public ClYxsj selectClYxsjById(Long id)
    {
        return clYxsjMapper.selectClYxsjById(id);
    }

    /**
     * 查询常量-岩性数据列表
     * 
     * @param clYxsj 常量-岩性数据
     * @return 常量-岩性数据
     */
    @Override
    public List<ClYxsj> selectClYxsjList(ClYxsj clYxsj)
    {
        return clYxsjMapper.selectClYxsjList(clYxsj);
    }

    /**
     * 新增常量-岩性数据
     * 
     * @param clYxsj 常量-岩性数据
     * @return 结果
     */
    @Override
    public int insertClYxsj(ClYxsj clYxsj)
    {
        return clYxsjMapper.insertClYxsj(clYxsj);
    }

    /**
     * 修改常量-岩性数据
     * 
     * @param clYxsj 常量-岩性数据
     * @return 结果
     */
    @Override
    public int updateClYxsj(ClYxsj clYxsj)
    {
        clYxsj.setUpdateTime(DateUtils.getNowDate());
        return clYxsjMapper.updateClYxsj(clYxsj);
    }

    /**
     * 批量删除常量-岩性数据
     * 
     * @param ids 需要删除的常量-岩性数据主键
     * @return 结果
     */
    @Override
    public int deleteClYxsjByIds(Long[] ids)
    {
        return clYxsjMapper.deleteClYxsjByIds(ids);
    }

    /**
     * 删除常量-岩性数据信息
     * 
     * @param id 常量-岩性数据主键
     * @return 结果
     */
    @Override
    public int deleteClYxsjById(Long id)
    {
        return clYxsjMapper.deleteClYxsjById(id);
    }
}
