package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.Mxfxjgb;
import com.zjsgfa.project.zjsgfa.service.IMxfxjgbService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 大模型分析Controller
 * 
 * @author ruoyi
 * @date 2025-10-22
 */
@RestController
@RequestMapping("/system/mxfxjgb")
public class MxfxjgbController extends BaseController
{
    @Autowired
    private IMxfxjgbService mxfxjgbService;

    /**
     * 查询大模型分析列表
     */
    //@PreAuthorize("@ss.hasPermi('system:mxfxjgb:list')")
    @GetMapping("/list")
    public TableDataInfo list(Mxfxjgb mxfxjgb)
    {
        startPage();
        List<Mxfxjgb> list = mxfxjgbService.selectMxfxjgbList(mxfxjgb);
        return getDataTable(list);
    }

    /**
     * 导出大模型分析列表
     */
    //@PreAuthorize("@ss.hasPermi('system:mxfxjgb:export')")
    @Log(title = "大模型分析", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, Mxfxjgb mxfxjgb)
    {
        List<Mxfxjgb> list = mxfxjgbService.selectMxfxjgbList(mxfxjgb);
        ExcelUtil<Mxfxjgb> util = new ExcelUtil<Mxfxjgb>(Mxfxjgb.class);
        util.exportExcel(response, list, "大模型分析数据");
    }

    /**
     * 获取大模型分析详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:mxfxjgb:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(mxfxjgbService.selectMxfxjgbById(id));
    }

    /**
     * 新增大模型分析
     */
    //@PreAuthorize("@ss.hasPermi('system:mxfxjgb:add')")
    @Log(title = "大模型分析", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody Mxfxjgb mxfxjgb)
    {
        return toAjax(mxfxjgbService.insertMxfxjgb(mxfxjgb));
    }

    /**
     * 修改大模型分析
     */
    //@PreAuthorize("@ss.hasPermi('system:mxfxjgb:edit')")
    @Log(title = "大模型分析", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody Mxfxjgb mxfxjgb)
    {
        return toAjax(mxfxjgbService.updateMxfxjgb(mxfxjgb));
    }

    /**
     * 删除大模型分析
     */
    //@PreAuthorize("@ss.hasPermi('system:mxfxjgb:remove')")
    @Log(title = "大模型分析", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(mxfxjgbService.deleteMxfxjgbByIds(ids));
    }
}
