package com.zjsgfa.project.zjsgfa.service.impl;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;

import cn.hutool.core.codec.Base64;
import com.zjsgfa.common.utils.DateUtils;
import com.zjsgfa.common.utils.StringUtils;
import com.zjsgfa.framework.util.RichTextProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.JcxxJkzpMapper;
import com.zjsgfa.project.zjsgfa.domain.JcxxJkzp;
import com.zjsgfa.project.zjsgfa.service.IJcxxJkzpService;

/**
 * 基础信息-井控专篇Service业务层处理
 * 
 * @author
 * @date 2025-07-24
 */
@Service
public class JcxxJkzpServiceImpl implements IJcxxJkzpService 
{
    @Autowired
    private JcxxJkzpMapper jcxxJkzpMapper;

    /**
     * 查询基础信息-井控专篇
     * 
     * @param id 基础信息-井控专篇主键
     * @return 基础信息-井控专篇
     */
    @Override
    public JcxxJkzp selectJcxxJkzpById(Long id)
    {
        JcxxJkzp jcxxJkzp = jcxxJkzpMapper.selectJcxxJkzpById(id);

        // 压缩富文本中的图片，设置质量和最大尺寸
        String compressedContent = RichTextProcessor.processRichText(
                jcxxJkzp.getZjkzz(),  // 你的富文本字段
                0.7f,  // 质量 0.0-1.0
                800,   // 最大宽度
                600    // 最大高度
        );

        // 设置压缩后的富文本
        jcxxJkzp.setZjkzz(compressedContent);


        String clcb = RichTextProcessor.processRichText(
                jcxxJkzp.getClcb(),  // 你的富文本字段
                0.7f,  // 质量 0.0-1.0
                800,   // 最大宽度
                600    // 最大高度
        );

        // 设置压缩后的富文本
        jcxxJkzp.setClcb(clcb);


        String jlgh = RichTextProcessor.processRichText(
                jcxxJkzp.getJlgh(),  // 你的富文本字段
                0.7f,  // 质量 0.0-1.0
                800,   // 最大宽度
                600    // 最大高度
        );

        // 设置压缩后的富文本
        jcxxJkzp.setJlgh(jlgh);

        String syyq = RichTextProcessor.processRichText(
                jcxxJkzp.getSyyq(),  // 你的富文本字段
                0.7f,  // 质量 0.0-1.0
                800,   // 最大宽度
                600    // 最大高度
        );

        // 设置压缩后的富文本
        jcxxJkzp.setSyyq(syyq);
        return jcxxJkzp;
    }

    /**
     * 查询基础信息-井控专篇列表
     * 
     * @param jcxxJkzp 基础信息-井控专篇
     * @return 基础信息-井控专篇
     */
    @Override
    public List<JcxxJkzp> selectJcxxJkzpList(JcxxJkzp jcxxJkzp)
    {
        List<JcxxJkzp> list = jcxxJkzpMapper.selectJcxxJkzpList(jcxxJkzp);
       list.stream().map(entity -> {
            // 压缩富文本中的图片，设置质量和最大尺寸
            String compressedContent = RichTextProcessor.processRichText(
                    entity.getZjkzz(),  // 你的富文本字段
                    0.7f,  // 质量 0.0-1.0
                    800,   // 最大宽度
                    600    // 最大高度
            );

            // 设置压缩后的富文本
            entity.setZjkzz(compressedContent);


            String clcb = RichTextProcessor.processRichText(
                    entity.getClcb(),  // 你的富文本字段
                    0.7f,  // 质量 0.0-1.0
                    800,   // 最大宽度
                    600    // 最大高度
            );

            // 设置压缩后的富文本
            entity.setClcb(clcb);


            String jlgh = RichTextProcessor.processRichText(
                    entity.getJlgh(),  // 你的富文本字段
                    0.7f,  // 质量 0.0-1.0
                    800,   // 最大宽度
                    600    // 最大高度
            );

            // 设置压缩后的富文本
            entity.setJlgh(jlgh);

            String syyq = RichTextProcessor.processRichText(
                    entity.getSyyq(),  // 你的富文本字段
                    0.7f,  // 质量 0.0-1.0
                    800,   // 最大宽度
                    600    // 最大高度
            );

            // 设置压缩后的富文本
            entity.setSyyq(syyq);
            return entity;
        }).collect(Collectors.toList());

        return list;
    }

    /**
     * 新增基础信息-井控专篇
     * 
     * @param jcxxJkzp 基础信息-井控专篇
     * @return 结果
     */
    @Override
    public int insertJcxxJkzp(JcxxJkzp jcxxJkzp)
    {
        if(StringUtils.isNotEmpty(jcxxJkzp.getZjkzz())){
            jcxxJkzp.setZjkzz(new String(Base64.decode(jcxxJkzp.getZjkzz()), StandardCharsets.UTF_8));
        }
        if(StringUtils.isNotEmpty(jcxxJkzp.getClcb())){
            jcxxJkzp.setClcb(new String(Base64.decode(jcxxJkzp.getClcb()), StandardCharsets.UTF_8));
        }
        if(StringUtils.isNotEmpty(jcxxJkzp.getJlgh())){
            jcxxJkzp.setJlgh(new String(Base64.decode(jcxxJkzp.getJlgh()), StandardCharsets.UTF_8));

        }
        if(StringUtils.isNotEmpty(jcxxJkzp.getSyyq())){
            jcxxJkzp.setSyyq(new String(Base64.decode(jcxxJkzp.getSyyq()), StandardCharsets.UTF_8));
        }
        return jcxxJkzpMapper.insertJcxxJkzp(jcxxJkzp);
    }

    /**
     * 修改基础信息-井控专篇
     * 
     * @param jcxxJkzp 基础信息-井控专篇
     * @return 结果
     */
    @Override
    public int updateJcxxJkzp(JcxxJkzp jcxxJkzp)
    {
        if(StringUtils.isNotEmpty(jcxxJkzp.getZjkzz())){
            jcxxJkzp.setZjkzz(new String(Base64.decode(jcxxJkzp.getZjkzz()), StandardCharsets.UTF_8));
        }
        if(StringUtils.isNotEmpty(jcxxJkzp.getClcb())){
            jcxxJkzp.setClcb(new String(Base64.decode(jcxxJkzp.getClcb()), StandardCharsets.UTF_8));
        }
        if(StringUtils.isNotEmpty(jcxxJkzp.getJlgh())){
            jcxxJkzp.setJlgh(new String(Base64.decode(jcxxJkzp.getJlgh()), StandardCharsets.UTF_8));

        }
        if(StringUtils.isNotEmpty(jcxxJkzp.getSyyq())){
            jcxxJkzp.setSyyq(new String(Base64.decode(jcxxJkzp.getSyyq()), StandardCharsets.UTF_8));
        }
        jcxxJkzp.setUpdateTime(DateUtils.getNowDate());
        return jcxxJkzpMapper.updateJcxxJkzp(jcxxJkzp);
    }

    /**
     * 批量删除基础信息-井控专篇
     * 
     * @param ids 需要删除的基础信息-井控专篇主键
     * @return 结果
     */
    @Override
    public int deleteJcxxJkzpByIds(Long[] ids)
    {
        return jcxxJkzpMapper.deleteJcxxJkzpByIds(ids);
    }

    /**
     * 删除基础信息-井控专篇信息
     * 
     * @param id 基础信息-井控专篇主键
     * @return 结果
     */
    @Override
    public int deleteJcxxJkzpById(Long id)
    {
        return jcxxJkzpMapper.deleteJcxxJkzpById(id);
    }
}
