package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 设计信息-套管柱数据对象 sj_tg_tgz
 * 
 * @author
 * @date 2025-07-17
 */
public class SjTgTgz extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 开次 */
    @Excel(name = "开次")
    private String kc;

    /** 井段 */
    @Excel(name = "井段")
    private String jd;

    /** 外径 */
    @Excel(name = "外径")
    private Double wj;

    /** 钢级 */
    @Excel(name = "钢级")
    private String gj;

    /** 壁厚 */
    @Excel(name = "壁厚")
    private Double bh;

    /** 扣型 */
    @Excel(name = "扣型")
    private String kx;

    /** 最佳上扣扭矩 */
    @Excel(name = "最佳上扣扭矩")
    private Double zjsknj;

    /** 长度 */
    @Excel(name = "长度")
    private Double cd;

    /** 钻井液密度 */
    @Excel(name = "钻井液密度")
    private Double zjymd;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setJh(String jh) 
    {
        this.jh = jh;
    }

    public String getJh() 
    {
        return jh;
    }

    public void setKc(String kc) 
    {
        this.kc = kc;
    }

    public String getKc() 
    {
        return kc;
    }

    public void setJd(String jd) 
    {
        this.jd = jd;
    }

    public String getJd() 
    {
        return jd;
    }

    public void setWj(Double wj) 
    {
        this.wj = wj;
    }

    public Double getWj() 
    {
        return wj;
    }

    public void setGj(String gj) 
    {
        this.gj = gj;
    }

    public String getGj() 
    {
        return gj;
    }

    public void setBh(Double bh) 
    {
        this.bh = bh;
    }

    public Double getBh() 
    {
        return bh;
    }

    public void setKx(String kx) 
    {
        this.kx = kx;
    }

    public String getKx() 
    {
        return kx;
    }

    public void setZjsknj(Double zjsknj) 
    {
        this.zjsknj = zjsknj;
    }

    public Double getZjsknj() 
    {
        return zjsknj;
    }

    public void setCd(Double cd) 
    {
        this.cd = cd;
    }

    public Double getCd() 
    {
        return cd;
    }

    public void setZjymd(Double zjymd) 
    {
        this.zjymd = zjymd;
    }

    public Double getZjymd() 
    {
        return zjymd;
    }

    public void setBz(String bz) 
    {
        this.bz = bz;
    }

    public String getBz() 
    {
        return bz;
    }

    public void setCreatedBy(String createdBy) 
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() 
    {
        return createdBy;
    }

    public void setCreatedTime(Date createdTime) 
    {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() 
    {
        return createdTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("jh", getJh())
            .append("kc", getKc())
            .append("jd", getJd())
            .append("wj", getWj())
            .append("gj", getGj())
            .append("bh", getBh())
            .append("kx", getKx())
            .append("zjsknj", getZjsknj())
            .append("cd", getCd())
            .append("zjymd", getZjymd())
            .append("bz", getBz())
            .append("createdBy", getCreatedBy())
            .append("createdTime", getCreatedTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
