package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjH2s;
import com.zjsgfa.project.zjsgfa.service.ISjH2sService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计信息-H2SController
 * 
 * @author
 * @date 2025-07-22
 */
@RestController
@RequestMapping("/system/sjH2s")
public class SjH2sController extends BaseController
{
    @Autowired
    private ISjH2sService sjH2sService;

    /**
     * 查询设计信息-H2S列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjH2s:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjH2s sjH2s)
    {
        startPage();
        List<SjH2s> list = sjH2sService.selectSjH2sList(sjH2s);
        return getDataTable(list);
    }

    /**
     * 导出设计信息-H2S列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjH2s:export')")
    @Log(title = "设计信息-H2S", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjH2s sjH2s)
    {
        List<SjH2s> list = sjH2sService.selectSjH2sList(sjH2s);
        ExcelUtil<SjH2s> util = new ExcelUtil<SjH2s>(SjH2s.class);
        util.exportExcel(response, list, "设计信息-H2S数据");
    }

    /**
     * 获取设计信息-H2S详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjH2s:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjH2sService.selectSjH2sById(id));
    }

    /**
     * 新增设计信息-H2S
     */
    //@PreAuthorize("@ss.hasPermi('system:sjH2s:add')")
    @Log(title = "设计信息-H2S", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjH2s sjH2s)
    {
        return toAjax(sjH2sService.insertSjH2s(sjH2s));
    }

    /**
     * 修改设计信息-H2S
     */
    //@PreAuthorize("@ss.hasPermi('system:sjH2s:edit')")
    @Log(title = "设计信息-H2S", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjH2s sjH2s)
    {
        return toAjax(sjH2sService.updateSjH2s(sjH2s));
    }

    /**
     * 删除设计信息-H2S
     */
    //@PreAuthorize("@ss.hasPermi('system:sjH2s:remove')")
    @Log(title = "设计信息-H2S", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjH2sService.deleteSjH2sByIds(ids));
    }
}
