package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjDcfxTsyx;
import com.zjsgfa.project.zjsgfa.service.ISjDcfxTsyxService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计-地层分析-特殊岩性提示Controller
 * 
 * @author
 * @date 2025-08-08
 */
@RestController
@RequestMapping("/system/sjDcfxTsyx")
public class SjDcfxTsyxController extends BaseController
{
    @Autowired
    private ISjDcfxTsyxService sjDcfxTsyxService;

    /**
     * 查询设计-地层分析-特殊岩性提示列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjDcfxTsyx:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjDcfxTsyx sjDcfxTsyx)
    {
//        startPage();
        List<SjDcfxTsyx> list = sjDcfxTsyxService.selectSjDcfxTsyxList(sjDcfxTsyx);
        return getDataTable(list);
    }

    /**
     * 导出设计-地层分析-特殊岩性提示列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjDcfxTsyx:export')")
    @Log(title = "设计-地层分析-特殊岩性提示", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjDcfxTsyx sjDcfxTsyx)
    {
        List<SjDcfxTsyx> list = sjDcfxTsyxService.selectSjDcfxTsyxList(sjDcfxTsyx);
        ExcelUtil<SjDcfxTsyx> util = new ExcelUtil<SjDcfxTsyx>(SjDcfxTsyx.class);
        util.exportExcel(response, list, "设计-地层分析-特殊岩性提示数据");
    }

    /**
     * 获取设计-地层分析-特殊岩性提示详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjDcfxTsyx:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjDcfxTsyxService.selectSjDcfxTsyxById(id));
    }

    /**
     * 新增设计-地层分析-特殊岩性提示
     */
    //@PreAuthorize("@ss.hasPermi('system:sjDcfxTsyx:add')")
    @Log(title = "设计-地层分析-特殊岩性提示", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjDcfxTsyx sjDcfxTsyx)
    {
        return toAjax(sjDcfxTsyxService.insertSjDcfxTsyx(sjDcfxTsyx));
    }

    /**
     * 修改设计-地层分析-特殊岩性提示
     */
    //@PreAuthorize("@ss.hasPermi('system:sjDcfxTsyx:edit')")
    @Log(title = "设计-地层分析-特殊岩性提示", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjDcfxTsyx sjDcfxTsyx)
    {
        return toAjax(sjDcfxTsyxService.updateSjDcfxTsyx(sjDcfxTsyx));
    }

    /**
     * 删除设计-地层分析-特殊岩性提示
     */
    //@PreAuthorize("@ss.hasPermi('system:sjDcfxTsyx:remove')")
    @Log(title = "设计-地层分析-特殊岩性提示", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjDcfxTsyxService.deleteSjDcfxTsyxByIds(ids));
    }
}
