package com.zjsgfa.project.zt.service;

import com.zjsgfa.project.zt.domain.Jsaa;

import java.util.List;

/**
 * 基础数据Service接口
 * 
 * @author
 * @date 2025-07-10
 */
public interface IJsaaService 
{
    /**
     * 查询基础数据
     * 
     * @param jh 基础数据主键
     * @return 基础数据
     */
    public Jsaa selectJsaaByJh(String jh);

    /**
     * 查询基础数据列表
     * 
     * @param jsaa 基础数据
     * @return 基础数据集合
     */
    public List<Jsaa> selectJsaaList(Jsaa jsaa);

    /**
     * 新增基础数据
     * 
     * @param jsaa 基础数据
     * @return 结果
     */
    public int insertJsaa(Jsaa jsaa);

    /**
     * 修改基础数据
     * 
     * @param jsaa 基础数据
     * @return 结果
     */
    public int updateJsaa(Jsaa jsaa);

    /**
     * 批量删除基础数据
     * 
     * @param jhs 需要删除的基础数据主键集合
     * @return 结果
     */
    public int deleteJsaaByJhs(String[] jhs);

    /**
     * 删除基础数据信息
     * 
     * @param jh 基础数据主键
     * @return 结果
     */
    public int deleteJsaaByJh(String jh);

    List<Jsaa> selectQklist(Jsaa jsaa);
}
