package com.zjsgfa.project.zt.domain;

import lombok.Data;

import java.time.LocalTime;

@Data
public class TimePointPair {
    private LocalTime previousTime;
    private LocalTime previousTime2;
    private LocalTime drillingTime;

    public TimePointPair(LocalTime previousTime, LocalTime drillingTime) {
        this.previousTime = previousTime;
        this.drillingTime = drillingTime;
    }
    public TimePointPair(LocalTime previousTime, LocalTime drillingTime,LocalTime previousTime2) {
        this.previousTime = previousTime;
        this.drillingTime = drillingTime;
        this.previousTime2 = previousTime2;
    }

    public LocalTime getPreviousTime() {
        return previousTime;
    }

    public LocalTime getDrillingTime() {
        return drillingTime;
    }

    // 判断两个时间点之间是否跨天
    public boolean isCrossDay() {
        boolean before = drillingTime.isBefore(previousTime);
        return before;
    }

    public boolean isCrossDay2() {
        if(previousTime2==null){
            return false;
        }
        return previousTime.isBefore(previousTime2);
    }

    @Override
    public String toString() {
        return previousTime + " - " + drillingTime;
    }

}
