package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 设计信息-钻井液材料加量对象 sj_zjy_cljl
 * 
 * @author
 * @date 2025-07-17
 */
@Data
public class SjZjyCljl extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 材料名称及代号 */
    @Excel(name = "材料名称及代号")
    private String clmc;

    /** 一开加量 （kg/m3） */
    @Excel(name = "一开加量 ", readConverterExp = "k=g/m3")
    private String ykjl;

    /** 二开加量 （kg/m3） */
    @Excel(name = "二开加量 ", readConverterExp = "k=g/m3")
    private String ekjl;

    /** 三开加量 （kg/m3） */
    @Excel(name = "三开加量 ", readConverterExp = "k=g/m3")
    private String skjl;

    /** 四开加量 （kg/m3） */
    @Excel(name = "四开加量 ", readConverterExp = "k=g/m3")
    private String sikjl;

    /** 五开加量 （kg/m3） */
    @Excel(name = "五开加量 ", readConverterExp = "k=g/m3")
    private String wkjl;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    private Integer num;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

}
