package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;
import lombok.Data;

/**
 * 查询条件对象 cxtj
 * 
 * @author ruoyi
 * @date 2025-09-12
 */
@Data
public class Cxtj extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 查询条件名称 */
    @Excel(name = "查询条件名称")
    private String cxtjmc;

    /** 区块 */
    @Excel(name = "区块")
    private String qk;

    /** 井号（多个） */
    @Excel(name = "井号", readConverterExp = "多=个")
    private String jh;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    private String lb;

    private String jhlist;

    private String sfgk;

}
