package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;
import lombok.Data;

/**
 * 文件对象 common_file
 * 
 * @author ruoyi
 * @date 2025-10-27
 */
@Data
public class CommonFile extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 业务id */
    @Excel(name = "业务id")
    private String businessId;

    /** 文件名 */
    @Excel(name = "文件名")
    private String fileName;

    /** 后缀名 */
    @Excel(name = "后缀名")
    private String fileSuffix;

    /** 文件类型 */
    @Excel(name = "文件类型")
    private String fileType;

    /** 文件路径 */
    @Excel(name = "文件路径")
    private String filePath;

    /** 业务类型 */
    @Excel(name = "业务类型")
    private String type;

    /** 模板名 */
    @Excel(name = "模板名")
    private String templateName;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    /** 备用1 */
    @Excel(name = "备用1")
    private String ext1;

    /** 备用2 */
    @Excel(name = "备用2")
    private String ext2;

    /** 备用3 */
    @Excel(name = "备用3")
    private String ext3;

    /** $column.columnComment */
    @Excel(name = "${comment}", readConverterExp = "$column.readConverterExp()")
    private Long height;

    /** $column.columnComment */
    @Excel(name = "${comment}", readConverterExp = "$column.readConverterExp()")
    private Long width;
}
