package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjJhzq;
import com.zjsgfa.project.zjsgfa.service.ISjJhzqService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计-计划周期Controller
 * 
 * @author
 * @date 2025-07-24
 */
@RestController
@RequestMapping("/system/sjJhzq")
public class SjJhzqController extends BaseController
{
    @Autowired
    private ISjJhzqService sjJhzqService;

    /**
     * 查询设计-计划周期列表
     */
    ////@PreAuthorize("@ss.hasPermi('system:sjJhzq:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjJhzq sjJhzq)
    {
//        startPage();
        List<SjJhzq> list = sjJhzqService.selectSjJhzqList(sjJhzq);
        return getDataTable(list);
    }

    /**
     * 导出设计-计划周期列表
     */
    ////@PreAuthorize("@ss.hasPermi('system:sjJhzq:export')")
    @Log(title = "设计-计划周期", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjJhzq sjJhzq)
    {
        List<SjJhzq> list = sjJhzqService.selectSjJhzqList(sjJhzq);
        ExcelUtil<SjJhzq> util = new ExcelUtil<SjJhzq>(SjJhzq.class);
        util.exportExcel(response, list, "设计-计划周期数据");
    }

    /**
     * 获取设计-计划周期详细信息
     */
    ////@PreAuthorize("@ss.hasPermi('system:sjJhzq:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjJhzqService.selectSjJhzqById(id));
    }

    /**
     * 新增设计-计划周期
     */
    ////@PreAuthorize("@ss.hasPermi('system:sjJhzq:add')")
    @Log(title = "设计-计划周期", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjJhzq sjJhzq)
    {
        return toAjax(sjJhzqService.insertSjJhzq(sjJhzq));
    }

    /**
     * 修改设计-计划周期
     */
    ////@PreAuthorize("@ss.hasPermi('system:sjJhzq:edit')")
    @Log(title = "设计-计划周期", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjJhzq sjJhzq)
    {
        return toAjax(sjJhzqService.updateSjJhzq(sjJhzq));
    }

    /**
     * 删除设计-计划周期
     */
    ////@PreAuthorize("@ss.hasPermi('system:sjJhzq:remove')")
    @Log(title = "设计-计划周期", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjJhzqService.deleteSjJhzqByIds(ids));
    }
}
