package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjFdsgcsZjfxzt;
import com.zjsgfa.project.zjsgfa.service.ISjFdsgcsZjfxztService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 分段施工措施-专家分析钻头Controller
 * 
 * @author ruoyi
 * @date 2025-12-10
 */
@RestController
@RequestMapping("/system/sjFdsgcsZjfxzt")
public class SjFdsgcsZjfxztController extends BaseController
{
    @Autowired
    private ISjFdsgcsZjfxztService sjFdsgcsZjfxztService;

    /**
     * 查询分段施工措施-专家分析钻头列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsZjfxzt:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjFdsgcsZjfxzt sjFdsgcsZjfxzt)
    {
//        startPage();
        List<SjFdsgcsZjfxzt> list = sjFdsgcsZjfxztService.selectSjFdsgcsZjfxztList(sjFdsgcsZjfxzt);
        return getDataTable(list);
    }

    /**
     * 导出分段施工措施-专家分析钻头列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsZjfxzt:export')")
    @Log(title = "分段施工措施-专家分析钻头", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjFdsgcsZjfxzt sjFdsgcsZjfxzt)
    {
        List<SjFdsgcsZjfxzt> list = sjFdsgcsZjfxztService.selectSjFdsgcsZjfxztList(sjFdsgcsZjfxzt);
        ExcelUtil<SjFdsgcsZjfxzt> util = new ExcelUtil<SjFdsgcsZjfxzt>(SjFdsgcsZjfxzt.class);
        util.exportExcel(response, list, "分段施工措施-专家分析钻头数据");
    }

    /**
     * 获取分段施工措施-专家分析钻头详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsZjfxzt:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjFdsgcsZjfxztService.selectSjFdsgcsZjfxztById(id));
    }

    /**
     * 新增分段施工措施-专家分析钻头
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsZjfxzt:add')")
    @Log(title = "分段施工措施-专家分析钻头", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjFdsgcsZjfxzt sjFdsgcsZjfxzt)
    {
        return toAjax(sjFdsgcsZjfxztService.insertSjFdsgcsZjfxzt(sjFdsgcsZjfxzt));
    }

    /**
     * 修改分段施工措施-专家分析钻头
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsZjfxzt:edit')")
    @Log(title = "分段施工措施-专家分析钻头", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjFdsgcsZjfxzt sjFdsgcsZjfxzt)
    {
        return toAjax(sjFdsgcsZjfxztService.updateSjFdsgcsZjfxzt(sjFdsgcsZjfxzt));
    }

    /**
     * 删除分段施工措施-专家分析钻头
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsZjfxzt:remove')")
    @Log(title = "分段施工措施-专家分析钻头", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjFdsgcsZjfxztService.deleteSjFdsgcsZjfxztByIds(ids));
    }
}
