package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.CommonFile;
import com.zjsgfa.project.zjsgfa.service.ICommonFileService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 文件Controller
 * 
 * @author ruoyi
 * @date 2025-10-27
 */
@RestController
@RequestMapping("/system/commonFile")
public class CommonFileController extends BaseController
{
    @Autowired
    private ICommonFileService commonFileService;

    /**
     * 查询文件列表
     */
    //@PreAuthorize("@ss.hasPermi('system:commonFile:list')")
    @GetMapping("/list")
    public TableDataInfo list(CommonFile commonFile)
    {
//        startPage();

        List<CommonFile> list = commonFileService.selectCommonFileList(commonFile);
        return getDataTable(list);
    }

    /**
     * 导出文件列表
     */
    //@PreAuthorize("@ss.hasPermi('system:commonFile:export')")
    @Log(title = "文件", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, CommonFile commonFile)
    {
        List<CommonFile> list = commonFileService.selectCommonFileList(commonFile);
        ExcelUtil<CommonFile> util = new ExcelUtil<CommonFile>(CommonFile.class);
        util.exportExcel(response, list, "文件数据");
    }

    /**
     * 获取文件详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:commonFile:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(commonFileService.selectCommonFileById(id));
    }

    /**
     * 新增文件
     */
    //@PreAuthorize("@ss.hasPermi('system:commonFile:add')")
    @Log(title = "文件", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody CommonFile commonFile)
    {
        return toAjax(commonFileService.insertCommonFile(commonFile));
    }

    /**
     * 修改文件
     */
    //@PreAuthorize("@ss.hasPermi('system:commonFile:edit')")
    @Log(title = "文件", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody CommonFile commonFile)
    {
        return toAjax(commonFileService.updateCommonFile(commonFile));
    }

    /**
     * 删除文件
     */
    //@PreAuthorize("@ss.hasPermi('system:commonFile:remove')")
    @Log(title = "文件", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(commonFileService.deleteCommonFileByIds(ids));
    }
}
