package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjFdfxMapper;
import com.zjsgfa.project.zjsgfa.domain.SjFdfx;
import com.zjsgfa.project.zjsgfa.service.ISjFdfxService;

/**
 * 设计-分段分析Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-09-11
 */
@Service
public class SjFdfxServiceImpl implements ISjFdfxService 
{
    @Autowired
    private SjFdfxMapper sjFdfxMapper;

    /**
     * 查询设计-分段分析
     * 
     * @param id 设计-分段分析主键
     * @return 设计-分段分析
     */
    @Override
    public SjFdfx selectSjFdfxById(Long id)
    {
        return sjFdfxMapper.selectSjFdfxById(id);
    }

    /**
     * 查询设计-分段分析列表
     * 
     * @param sjFdfx 设计-分段分析
     * @return 设计-分段分析
     */
    @Override
    public List<SjFdfx> selectSjFdfxList(SjFdfx sjFdfx)
    {
        return sjFdfxMapper.selectSjFdfxList(sjFdfx);
    }

    /**
     * 新增设计-分段分析
     * 
     * @param sjFdfx 设计-分段分析
     * @return 结果
     */
    @Override
    public int insertSjFdfx(SjFdfx sjFdfx)
    {
        return sjFdfxMapper.insertSjFdfx(sjFdfx);
    }

    /**
     * 修改设计-分段分析
     * 
     * @param sjFdfx 设计-分段分析
     * @return 结果
     */
    @Override
    public int updateSjFdfx(SjFdfx sjFdfx)
    {
        return sjFdfxMapper.updateSjFdfx(sjFdfx);
    }

    /**
     * 批量删除设计-分段分析
     * 
     * @param ids 需要删除的设计-分段分析主键
     * @return 结果
     */
    @Override
    public int deleteSjFdfxByIds(Long[] ids)
    {
        return sjFdfxMapper.deleteSjFdfxByIds(ids);
    }

    /**
     * 删除设计-分段分析信息
     * 
     * @param id 设计-分段分析主键
     * @return 结果
     */
    @Override
    public int deleteSjFdfxById(Long id)
    {
        return sjFdfxMapper.deleteSjFdfxById(id);
    }
}
