package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjJygjInfo;
import com.zjsgfa.project.zjsgfa.service.ISjJygjInfoService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计信息-井眼轨迹信息Controller
 * 
 * @author
 * @date 2025-06-26
 */
@RestController
@RequestMapping("/system/sjJygjInfo")
public class SjJygjInfoController extends BaseController
{
    @Autowired
    private ISjJygjInfoService sjJygjInfoService;

    /**
     * 查询设计信息-井眼轨迹信息列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJygjInfo:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjJygjInfo sjJygjInfo)
    {
//        startPage();
        List<SjJygjInfo> list = sjJygjInfoService.selectSjJygjInfoList(sjJygjInfo);
        return getDataTable(list);
    }

    /**
     * 导出设计信息-井眼轨迹信息列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJygjInfo:export')")
    @Log(title = "设计信息-井眼轨迹信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjJygjInfo sjJygjInfo)
    {
        List<SjJygjInfo> list = sjJygjInfoService.selectSjJygjInfoList(sjJygjInfo);
        ExcelUtil<SjJygjInfo> util = new ExcelUtil<SjJygjInfo>(SjJygjInfo.class);
        util.exportExcel(response, list, "设计信息-井眼轨迹信息数据");
    }

    /**
     * 获取设计信息-井眼轨迹信息详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJygjInfo:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjJygjInfoService.selectSjJygjInfoById(id));
    }

    /**
     * 新增设计信息-井眼轨迹信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJygjInfo:add')")
    @Log(title = "设计信息-井眼轨迹信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjJygjInfo sjJygjInfo)
    {
        return toAjax(sjJygjInfoService.insertSjJygjInfo(sjJygjInfo));
    }

    /**
     * 修改设计信息-井眼轨迹信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJygjInfo:edit')")
    @Log(title = "设计信息-井眼轨迹信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjJygjInfo sjJygjInfo)
    {
        return toAjax(sjJygjInfoService.updateSjJygjInfo(sjJygjInfo));
    }

    /**
     * 删除设计信息-井眼轨迹信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJygjInfo:remove')")
    @Log(title = "设计信息-井眼轨迹信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjJygjInfoService.deleteSjJygjInfoByIds(ids));
    }
}
