package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjFdfx;
import com.zjsgfa.project.zjsgfa.service.ISjFdfxService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计-分段分析Controller
 * 
 * @author ruoyi
 * @date 2025-09-11
 */
@RestController
@RequestMapping("/system/sjFdfx")
public class SjFdfxController extends BaseController
{
    @Autowired
    private ISjFdfxService sjFdfxService;

    /**
     * 查询设计-分段分析列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdfx:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjFdfx sjFdfx)
    {
        startPage();
        List<SjFdfx> list = sjFdfxService.selectSjFdfxList(sjFdfx);
        return getDataTable(list);
    }

    /**
     * 导出设计-分段分析列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdfx:export')")
    @Log(title = "设计-分段分析", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjFdfx sjFdfx)
    {
        List<SjFdfx> list = sjFdfxService.selectSjFdfxList(sjFdfx);
        ExcelUtil<SjFdfx> util = new ExcelUtil<SjFdfx>(SjFdfx.class);
        util.exportExcel(response, list, "设计-分段分析数据");
    }

    /**
     * 获取设计-分段分析详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdfx:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjFdfxService.selectSjFdfxById(id));
    }

    /**
     * 新增设计-分段分析
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdfx:add')")
    @Log(title = "设计-分段分析", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjFdfx sjFdfx)
    {
        return toAjax(sjFdfxService.insertSjFdfx(sjFdfx));
    }

    /**
     * 修改设计-分段分析
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdfx:edit')")
    @Log(title = "设计-分段分析", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjFdfx sjFdfx)
    {
        return toAjax(sjFdfxService.updateSjFdfx(sjFdfx));
    }

    /**
     * 删除设计-分段分析
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdfx:remove')")
    @Log(title = "设计-分段分析", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjFdfxService.deleteSjFdfxByIds(ids));
    }
}
