package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.JcxxJkzp;
import com.zjsgfa.project.zjsgfa.service.IJcxxJkzpService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 基础信息-井控专篇Controller
 * 
 * @author
 * @date 2025-07-24
 */
@RestController
@RequestMapping("/system/jcxxJkzp")
public class JcxxJkzpController extends BaseController
{
    @Autowired
    private IJcxxJkzpService jcxxJkzpService;

    /**
     * 查询基础信息-井控专篇列表
     */
    @PreAuthorize("@ss.hasPermi('system:jcxxJkzp:list')")
    @GetMapping("/list")
    public TableDataInfo list(JcxxJkzp jcxxJkzp)
    {
        startPage();
        List<JcxxJkzp> list = jcxxJkzpService.selectJcxxJkzpList(jcxxJkzp);
        return getDataTable(list);
    }

    /**
     * 导出基础信息-井控专篇列表
     */
    @PreAuthorize("@ss.hasPermi('system:jcxxJkzp:export')")
    @Log(title = "基础信息-井控专篇", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, JcxxJkzp jcxxJkzp)
    {
        List<JcxxJkzp> list = jcxxJkzpService.selectJcxxJkzpList(jcxxJkzp);
        ExcelUtil<JcxxJkzp> util = new ExcelUtil<JcxxJkzp>(JcxxJkzp.class);
        util.exportExcel(response, list, "基础信息-井控专篇数据");
    }

    /**
     * 获取基础信息-井控专篇详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:jcxxJkzp:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(jcxxJkzpService.selectJcxxJkzpById(id));
    }

    /**
     * 新增基础信息-井控专篇
     */
    @PreAuthorize("@ss.hasPermi('system:jcxxJkzp:add')")
    @Log(title = "基础信息-井控专篇", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody JcxxJkzp jcxxJkzp)
    {
        return toAjax(jcxxJkzpService.insertJcxxJkzp(jcxxJkzp));
    }

    /**
     * 修改基础信息-井控专篇
     */
    @PreAuthorize("@ss.hasPermi('system:jcxxJkzp:edit')")
    @Log(title = "基础信息-井控专篇", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody JcxxJkzp jcxxJkzp)
    {
        return toAjax(jcxxJkzpService.updateJcxxJkzp(jcxxJkzp));
    }

    /**
     * 删除基础信息-井控专篇
     */
    @PreAuthorize("@ss.hasPermi('system:jcxxJkzp:remove')")
    @Log(title = "基础信息-井控专篇", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(jcxxJkzpService.deleteJcxxJkzpByIds(ids));
    }
}
