package com.zjsgfa.project.zjsgfa.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.zjsgfa.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjJygjGdsjgdcsMapper;
import com.zjsgfa.project.zjsgfa.domain.SjJygjGdsjgdcs;
import com.zjsgfa.project.zjsgfa.service.ISjJygjGdsjgdcsService;

/**
 * 设计信息-井眼轨迹_轨道设计各点参数Service业务层处理
 * 
 * @author
 * @date 2025-06-26
 */
@Service
public class SjJygjGdsjgdcsServiceImpl implements ISjJygjGdsjgdcsService 
{
    @Autowired
    private SjJygjGdsjgdcsMapper sjJygjGdsjgdcsMapper;

    /**
     * 查询设计信息-井眼轨迹_轨道设计各点参数
     * 
     * @param id 设计信息-井眼轨迹_轨道设计各点参数主键
     * @return 设计信息-井眼轨迹_轨道设计各点参数
     */
    @Override
    public SjJygjGdsjgdcs selectSjJygjGdsjgdcsById(Long id)
    {
        return sjJygjGdsjgdcsMapper.selectSjJygjGdsjgdcsById(id);
    }

    /**
     * 查询设计信息-井眼轨迹_轨道设计各点参数列表
     * 
     * @param sjJygjGdsjgdcs 设计信息-井眼轨迹_轨道设计各点参数
     * @return 设计信息-井眼轨迹_轨道设计各点参数
     */
    @Override
    public List<SjJygjGdsjgdcs> selectSjJygjGdsjgdcsList(SjJygjGdsjgdcs sjJygjGdsjgdcs)
    {
        return sjJygjGdsjgdcsMapper.selectSjJygjGdsjgdcsList(sjJygjGdsjgdcs);
    }

    /**
     * 新增设计信息-井眼轨迹_轨道设计各点参数
     * 
     * @param sjJygjGdsjgdcs 设计信息-井眼轨迹_轨道设计各点参数
     * @return 结果
     */
    @Override
    public int insertSjJygjGdsjgdcs(SjJygjGdsjgdcs sjJygjGdsjgdcs)
    {
        return sjJygjGdsjgdcsMapper.insertSjJygjGdsjgdcs(sjJygjGdsjgdcs);
    }

    /**
     * 修改设计信息-井眼轨迹_轨道设计各点参数
     * 
     * @param sjJygjGdsjgdcs 设计信息-井眼轨迹_轨道设计各点参数
     * @return 结果
     */
    @Override
    public int updateSjJygjGdsjgdcs(SjJygjGdsjgdcs sjJygjGdsjgdcs)
    {
        sjJygjGdsjgdcs.setUpdateTime(DateUtils.getNowDate());
        return sjJygjGdsjgdcsMapper.updateSjJygjGdsjgdcs(sjJygjGdsjgdcs);
    }

    /**
     * 批量删除设计信息-井眼轨迹_轨道设计各点参数
     * 
     * @param ids 需要删除的设计信息-井眼轨迹_轨道设计各点参数主键
     * @return 结果
     */
    @Override
    public int deleteSjJygjGdsjgdcsByIds(Long[] ids)
    {
        return sjJygjGdsjgdcsMapper.deleteSjJygjGdsjgdcsByIds(ids);
    }

    /**
     * 删除设计信息-井眼轨迹_轨道设计各点参数信息
     * 
     * @param id 设计信息-井眼轨迹_轨道设计各点参数主键
     * @return 结果
     */
    @Override
    public int deleteSjJygjGdsjgdcsById(Long id)
    {
        return sjJygjGdsjgdcsMapper.deleteSjJygjGdsjgdcsById(id);
    }

    @Override
    public Map jygjEw(SjJygjGdsjgdcs sjJygjGdsjgdcs) {
        List<SjJygjGdsjgdcs> gjlist = sjJygjGdsjgdcsMapper.selectSjJygjGdsjgdcsList(sjJygjGdsjgdcs);
        // 水平投影
        Map sptymap =new HashMap();
        List spList = new ArrayList<>();
        sptymap.put("data",spList);
        if(gjlist.size()==0){
            return back("数据不存在");
        }
        // 垂直投影
        Map cztymap =new HashMap();
        List czList = new ArrayList<>();
        cztymap.put("data",czList);

        // 垂直投影坐标范围
        Double maxcs = 0.0;
        Double maxsp = 0.0;
        Double minsp = 0.0;


        // 水平投影使用范围
        Double maxnb =  0.0;
        Double minnb =  0.0;

        Double maxdx =  0.0;
        Double mindx =  0.0;

        maxcs= gjlist.stream().map(SjJygjGdsjgdcs::getCs).max(Double::compare).get();
        maxsp= gjlist.stream().map(SjJygjGdsjgdcs::getSpy).max(Double::compare).get();
        minsp= gjlist.stream().map(SjJygjGdsjgdcs::getSpy).min(Double::compare).get();
        maxnb= gjlist.stream().map(SjJygjGdsjgdcs::getNbwy).max(Double::compare).get();
        minnb= gjlist.stream().map(SjJygjGdsjgdcs::getNbwy).min(Double::compare).get();
        maxdx= gjlist.stream().map(SjJygjGdsjgdcs::getDxwy).max(Double::compare).get();
        mindx= gjlist.stream().map(SjJygjGdsjgdcs::getDxwy).min(Double::compare).get();


        for(int i=0;i<gjlist.size();i++){
            SjJygjGdsjgdcs dw = gjlist.get(i);
            if (dw.getCs()==null||dw.getNbwy()==null||dw.getDxwy()==null||dw.getSpy()==null) {
                return  back("数据存在空值");
            }

            Double cs = dw.getCs(); // 垂深
            Double sp = dw.getSpy(); // 水平
            Double nb = dw.getNbwy(); // 南北
            Double dx = dw.getDxwy(); // 东西
            Map spd =new HashMap(); // 水平投影的点
            spd.put("y",nb); // 给N北  南北位移
            spd.put("x",dx); //给E东  东西位移
            spList.add(spd);
            Map czd =new HashMap(); // 垂直投影的点
            czd.put("y",cs); // 垂深
            czd.put("x",sp);// 水平位移
            czList.add(czd);
        }
        sptymap.put("xmax",maxdx);
        sptymap.put("xmin",mindx);
        sptymap.put("ymax",maxnb);
        sptymap.put("ymin",minnb);


        cztymap.put("xmax",maxsp+500);  // +1000
        cztymap.put("xmin",minsp-300);
        cztymap.put("ymax",maxcs+500);// +1000
        cztymap.put("ymin",0);

        Map map =new HashMap();
        map.put("code",200);
        map.put("msg","成功");
        map.put("sptymap",sptymap);
        map.put("cztymap",cztymap);
        return map;
    }

    @Override
    public Map jygjSw(SjJygjGdsjgdcs sjJygjGdsjgdcs) {
        List<SjJygjGdsjgdcs> gjlist = sjJygjGdsjgdcsMapper.selectSjJygjGdsjgdcsList(sjJygjGdsjgdcs);
        // 三维坐标
        Map swmap =new HashMap();
        List swList = new ArrayList<>();
        swmap.put("lineData",swList);

        if(gjlist.size()==0){
            return back("数据不存在");
        }
        Double maxcs =gjlist.stream().map(SjJygjGdsjgdcs::getCs).max(Double::compare).get();;

        Double maxnb =  0.0;
        Double minnb =  0.0;
        Double maxdx =  0.0;
        Double mindx =  0.0;

        maxcs= gjlist.stream().map(SjJygjGdsjgdcs::getCs).max(Double::compare).get();
        maxnb= gjlist.stream().map(SjJygjGdsjgdcs::getNbwy).max(Double::compare).get();
        minnb= gjlist.stream().map(SjJygjGdsjgdcs::getNbwy).min(Double::compare).get();
        maxdx= gjlist.stream().map(SjJygjGdsjgdcs::getDxwy).max(Double::compare).get();
        mindx= gjlist.stream().map(SjJygjGdsjgdcs::getDxwy).min(Double::compare).get();

        for(int i=0;i<gjlist.size();i++){
            SjJygjGdsjgdcs dw = gjlist.get(i);
            if (dw.getCs()==null||dw.getNbwy()==null||dw.getDxwy()==null) {
                return  back("数据存在空值");
            }

            Double cs = dw.getCs(); // 垂深
            Double nb = dw.getNbwy(); // 南北
            Double dx = dw.getDxwy(); // 东西
            Double gtd = dw.getQjbhl(); // 狗腿度

            Map swd =new HashMap(); // 三维的点
            swd.put("value",new String[] {dx.toString(),nb.toString(),cs.toString()});
            swd.put("params",gtd); // 狗腿度
            swList.add(swd);
        }
        swmap.put("xmax",maxdx+100); // +100
        swmap.put("xmin",mindx-100); // -100

        swmap.put("ymax",maxnb+100); // +100
        swmap.put("ymin",minnb-100); // -100

        swmap.put("zmax", new BigDecimal(0)  ); // +100
        swmap.put("zmin",maxcs+1000); // +1000



        Map map =new HashMap();
        map.put("code",200);
        map.put("msg","成功");
        map.put("swmap",swmap);

        return map;
    }

    public  static Map back(String msg) {
        Map map =new HashMap();
        map.put("code",500);
        map.put("msg",msg);
        return map;
    }

}
