package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import com.zjsgfa.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjDzfcMapper;
import com.zjsgfa.project.zjsgfa.domain.SjDzfc;
import com.zjsgfa.project.zjsgfa.service.ISjDzfcService;

/**
 * 地质分层Service业务层处理
 * 
 * @author
 * @date 2025-07-07
 */
@Service
public class SjDzfcServiceImpl implements ISjDzfcService 
{
    @Autowired
    private SjDzfcMapper sjDzfcMapper;

    /**
     * 查询地质分层
     * 
     * @param id 地质分层主键
     * @return 地质分层
     */
    @Override
    public SjDzfc selectSjDzfcById(Long id)
    {
        return sjDzfcMapper.selectSjDzfcById(id);
    }

    /**
     * 查询地质分层列表
     * 
     * @param sjDzfc 地质分层
     * @return 地质分层
     */
    @Override
    public List<SjDzfc> selectSjDzfcList(SjDzfc sjDzfc)
    {
        return sjDzfcMapper.selectSjDzfcList(sjDzfc);
    }

    /**
     * 新增地质分层
     * 
     * @param sjDzfc 地质分层
     * @return 结果
     */
    @Override
    public int insertSjDzfc(SjDzfc sjDzfc)
    {
        return sjDzfcMapper.insertSjDzfc(sjDzfc);
    }

    /**
     * 修改地质分层
     * 
     * @param sjDzfc 地质分层
     * @return 结果
     */
    @Override
    public int updateSjDzfc(SjDzfc sjDzfc)
    {
        sjDzfc.setUpdateTime(DateUtils.getNowDate());
        return sjDzfcMapper.updateSjDzfc(sjDzfc);
    }

    /**
     * 批量删除地质分层
     * 
     * @param ids 需要删除的地质分层主键
     * @return 结果
     */
    @Override
    public int deleteSjDzfcByIds(Long[] ids)
    {
        return sjDzfcMapper.deleteSjDzfcByIds(ids);
    }

    /**
     * 删除地质分层信息
     * 
     * @param id 地质分层主键
     * @return 结果
     */
    @Override
    public int deleteSjDzfcById(Long id)
    {
        return sjDzfcMapper.deleteSjDzfcById(id);
    }
}
