package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;
import lombok.Data;

/**
 * 施工方案模板-条件配置对象 sgfamb_tjpz
 * 
 * @author ruoyi
 * @date 2025-09-25
 */
@Data
public class SgfambTjpz extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 条件名称 */
    @Excel(name = "条件名称")
    private String tjmc;

    /** 类别(钻头、钻具组合、施工参数) */
    @Excel(name = "类别(钻头、钻具组合、施工参数)")
    private String lb;

    /** 描述 */
    @Excel(name = "描述")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;
}
