package com.zjsgfa.project.zjsgfa.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;
import lombok.Data;

/**
 * 施工方案模板管理—开次-施工概要对象 sgfamb_kc_sggy
 * 
 * @author ruoyi
 * @date 2025-09-23
 */
@Data
public class SgfambKcSggy extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 主表id */
    @Excel(name = "主表id")
    private Long zbid;

    /** 开次 */
    @Excel(name = "开次")
    private String kc;

    private String qk;

    /** 开始井深 */
    @Excel(name = "开始井深")
    private BigDecimal ksjs;

    /** 结束井深 */
    @Excel(name = "结束井深")
    private BigDecimal jsjs;

    /** 钻头型号 */
    @Excel(name = "钻头型号")
    private String ztxh;

    /** 钻压 */
    @Excel(name = "钻压")
    private String zjzy;

    /** 转速 */
    @Excel(name = "转速")
    private String zjzs;

    /** 排量 */
    @Excel(name = "排量")
    private String zjpl;

    /** 泵压 */
    @Excel(name = "泵压")
    private String zjby;

    /** 钻具组合 */
    @Excel(name = "钻具组合")
    private String zjzh;

    /** 钻具组合注意事项 */
    @Excel(name = "钻具组合注意事项")
    private String zjzhzysx;

    /** 轨迹分析 */
    @Excel(name = "轨迹分析")
    private String gjfx;

    /** 轨迹优化 */
    @Excel(name = "轨迹优化")
    private String gjyh;

    /** 钻井液措施 */
    @Excel(name = "钻井液措施")
    private String zjycs;

    /** 钻井工程措施 */
    @Excel(name = "钻井工程措施")
    private String zjgccs;

    private String fxts;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    private String tjmc;

    //钻头条件id
    private Long zttjid;
    //钻具组合条件id
    private Long zjzhtjid;
    //施工参数条件id
    private Long sgcstjid;

    //钻压上限
    private String zjzysx;
    //转速上限
    private String zjzssx;
    //排量上限
    private String zjplsx;
    //泵压上限
    private String zjbysx;

    /** 厂家 */
    @Excel(name = "厂家")
    private String cj;

    /** 尺寸 */
    @Excel(name = "尺寸")
    private String cc;

    /** 水眼 */
    @Excel(name = "水眼")
    private String sy;

    /** 压降 */
    @Excel(name = "压降")
    private String yj;

    /** 钻井液密度 */
    @Excel(name = "钻井液密度")
    private String zjymd;

    /** 刀翼 */
    @Excel(name = "刀翼")
    private String dy;

    /** 复合片 */
    @Excel(name = "复合片")
    private String ffp;

    /** 复合片齿形 */
    @Excel(name = "复合片齿形")
    private String ffpcx;



}
