package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 大模型分析对象 mxfxjgb
 * 
 * @author ruoyi
 * @date 2025-10-22
 */
@Data
public class Mxfxjgb extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 模块类型 */
    @Excel(name = "模块类型")
    private String mklx;

    /** 任务类型(方案优化/文本优化) */
    @Excel(name = "任务类型(方案优化/文本优化)")
    private String rwlx;

    /** 任务名称 */
    @Excel(name = "任务名称")
    private String rwmc;

    /** 任务时间 */
    @Excel(name = "任务时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date rwsj;

    /** 解析状态 */
    @Excel(name = "解析状态")
    private String jxzt;

    /** 返回结果 */
    @Excel(name = "返回结果")
    private String fhjg;

    /** url地址 */
    @Excel(name = "url地址")
    private String url;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

}
