package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.Dzgzzb;
import com.zjsgfa.project.zjsgfa.service.IDzgzzbService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 地质构造总Controller
 * 
 * @author
 * @date 2025-07-08
 */
@RestController
@RequestMapping("/system/dzgzzb")
public class DzgzzbController extends BaseController
{
    @Autowired
    private IDzgzzbService dzgzzbService;

    /**
     * 查询地质构造总列表
     */
    @PreAuthorize("@ss.hasPermi('system:dzgzzb:list')")
    @GetMapping("/list")
    public TableDataInfo list(Dzgzzb dzgzzb)
    {
        startPage();
        List<Dzgzzb> list = dzgzzbService.selectDzgzzbList(dzgzzb);
        return getDataTable(list);
    }

    /**
     * 导出地质构造总列表
     */
    @PreAuthorize("@ss.hasPermi('system:dzgzzb:export')")
    @Log(title = "地质构造总", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, Dzgzzb dzgzzb)
    {
        List<Dzgzzb> list = dzgzzbService.selectDzgzzbList(dzgzzb);
        ExcelUtil<Dzgzzb> util = new ExcelUtil<Dzgzzb>(Dzgzzb.class);
        util.exportExcel(response, list, "地质构造总数据");
    }

    /**
     * 获取地质构造总详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:dzgzzb:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(dzgzzbService.selectDzgzzbById(id));
    }

    /**
     * 新增地质构造总
     */
    @PreAuthorize("@ss.hasPermi('system:dzgzzb:add')")
    @Log(title = "地质构造总", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody Dzgzzb dzgzzb)
    {
        return toAjax(dzgzzbService.insertDzgzzb(dzgzzb));
    }

    /**
     * 修改地质构造总
     */
    @PreAuthorize("@ss.hasPermi('system:dzgzzb:edit')")
    @Log(title = "地质构造总", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody Dzgzzb dzgzzb)
    {
        return toAjax(dzgzzbService.updateDzgzzb(dzgzzb));
    }

    /**
     * 删除地质构造总
     */
    @PreAuthorize("@ss.hasPermi('system:dzgzzb:remove')")
    @Log(title = "地质构造总", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(dzgzzbService.deleteDzgzzbByIds(ids));
    }
}
