package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.zjsgfa.common.utils.SecurityUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.Cxtj;
import com.zjsgfa.project.zjsgfa.service.ICxtjService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 查询条件Controller
 * 
 * @author ruoyi
 * @date 2025-09-12
 */
@RestController
@RequestMapping("/system/cxtj")
public class CxtjController extends BaseController
{
    @Autowired
    private ICxtjService cxtjService;

    /**
     * 查询查询条件列表
     */
   //@PreAuthorize("@ss.hasPermi('system:cxtj:list')")
    @GetMapping("/list")
    public TableDataInfo list(Cxtj cxtj)
    {
        startPage();
        cxtj.setCreatedBy(SecurityUtils.getUsername());
        List<Cxtj> list = cxtjService.selectCxtjList(cxtj);
        return getDataTable(list);
    }

    /**
     * 导出查询条件列表
     */
   //@PreAuthorize("@ss.hasPermi('system:cxtj:export')")
    @Log(title = "查询条件", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, Cxtj cxtj)
    {
        List<Cxtj> list = cxtjService.selectCxtjList(cxtj);
        ExcelUtil<Cxtj> util = new ExcelUtil<Cxtj>(Cxtj.class);
        util.exportExcel(response, list, "查询条件数据");
    }

    /**
     * 获取查询条件详细信息
     */
   //@PreAuthorize("@ss.hasPermi('system:cxtj:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(cxtjService.selectCxtjById(id));
    }

    /**
     * 新增查询条件
     */
   //@PreAuthorize("@ss.hasPermi('system:cxtj:add')")
    @Log(title = "查询条件", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody Cxtj cxtj)
    {
        return toAjax(cxtjService.insertCxtj(cxtj));
    }

    /**
     * 修改查询条件
     */
   //@PreAuthorize("@ss.hasPermi('system:cxtj:edit')")
    @Log(title = "查询条件", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody Cxtj cxtj)
    {
        return toAjax(cxtjService.updateCxtj(cxtj));
    }

    /**
     * 删除查询条件
     */
   //@PreAuthorize("@ss.hasPermi('system:cxtj:remove')")
    @Log(title = "查询条件", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(cxtjService.deleteCxtjByIds(ids));
    }
}
