package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;

import com.zjsgfa.common.utils.StringUtils;
import com.zjsgfa.project.zjsgfa.domain.SjJsjg;
import com.zjsgfa.project.zjsgfa.domain.SjSggyZjzhcs;
import com.zjsgfa.project.zjsgfa.mapper.SjJsjgMapper;
import com.zjsgfa.project.zjsgfa.mapper.SjSggyZjzhcsMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjZjcsxxMapper;
import com.zjsgfa.project.zjsgfa.domain.SjZjcsxx;
import com.zjsgfa.project.zjsgfa.service.ISjZjcsxxService;

/**
 * 设计-钻具参数信息Service业务层处理
 * 
 * @author
 * @date 2025-08-18
 */
@Service
public class SjZjcsxxServiceImpl implements ISjZjcsxxService 
{
    @Autowired
    private SjZjcsxxMapper sjZjcsxxMapper;

    @Autowired
    private SjSggyZjzhcsMapper sjSggyZjzhcsMapper;


    @Autowired
    private SjJsjgMapper sjJsjgMapper;

    /**
     * 查询设计-钻具参数信息
     * 
     * @param id 设计-钻具参数信息主键
     * @return 设计-钻具参数信息
     */
    @Override
    public SjZjcsxx selectSjZjcsxxById(Long id)
    {
        return sjZjcsxxMapper.selectSjZjcsxxById(id);
    }

    /**
     * 查询设计-钻具参数信息列表
     * 
     * @param sjZjcsxx 设计-钻具参数信息
     * @return 设计-钻具参数信息
     */
    @Override
    public List<SjZjcsxx> selectSjZjcsxxList(SjZjcsxx sjZjcsxx)
    {
        return sjZjcsxxMapper.selectSjZjcsxxList(sjZjcsxx);
    }

    /**
     * 新增设计-钻具参数信息
     * 
     * @param sjZjcsxx 设计-钻具参数信息
     * @return 结果
     */
    @Override
    public int insertSjZjcsxx(SjZjcsxx sjZjcsxx)
    {

        return sjZjcsxxMapper.insertSjZjcsxx(sjZjcsxx);
    }

    /**
     * 修改设计-钻具参数信息
     * 
     * @param sjZjcsxx 设计-钻具参数信息
     * @return 结果
     */
    @Override
    public int updateSjZjcsxx(SjZjcsxx sjZjcsxx)
    {

        SjSggyZjzhcs sjSggyZjzhcs= new SjSggyZjzhcs();
        sjSggyZjzhcs.setJh(sjZjcsxx.getJh());
        sjSggyZjzhcs.setKc(sjZjcsxx.getKc());
        SjSggyZjzhcs sjSggyZjzhcs1 = sjSggyZjzhcsMapper.selectSjSggyZjzhcsByZjzhcs(sjSggyZjzhcs);
        //查询井段信息
        SjJsjg sjJsjg = new SjJsjg();
        sjJsjg.setJh(sjZjcsxx.getJh());
        List<SjJsjg> sjJsjgList = sjJsjgMapper.selectSjJsjgList(sjJsjg);
        double ksjs=0;
        String jd ="";
        for(int i=0;i<sjJsjgList.size();i++) {
            SjJsjg sjJsjg1 = sjJsjgList.get(i);
            if(sjZjcsxx.getKc().equals(sjZjcsxx.getKc())){
                if (i == 0) {
                    ksjs = 0;
                } else {
                    ksjs = sjJsjgList.get(i - 1).getJs();
                }
                jd=ksjs+"-"+sjJsjg1.getJs();

            }
        }
        if(sjSggyZjzhcs1!=null){
            sjSggyZjzhcs1.setJd(jd);
            sjSggyZjzhcs1.setZtxh(sjZjcsxx.getZtxh());
            sjSggyZjzhcs1.setCc(sjZjcsxx.getCc());
            sjSggyZjzhcs1.setSy(sjZjcsxx.getSy());
            sjSggyZjzhcs1.setZjymd(sjZjcsxx.getZjymd());
            sjSggyZjzhcs1.setCj(sjZjcsxx.getCj());
            sjSggyZjzhcs1.setYj(sjZjcsxx.getYj());
            sjSggyZjzhcs1.setZjzy(StringUtils.isNotEmpty(sjZjcsxx.getZjzysx())?sjZjcsxx.getZjzy()+"-"+sjZjcsxx.getZjzysx():sjZjcsxx.getZjzy());
            sjSggyZjzhcs1.setZjzs(StringUtils.isNotEmpty(sjZjcsxx.getZjzssx())?sjZjcsxx.getZjzs()+"-"+sjZjcsxx.getZjzssx():sjZjcsxx.getZjzs());
            sjSggyZjzhcs1.setZjby(StringUtils.isNotEmpty(sjZjcsxx.getZjbysx())?sjZjcsxx.getZjby()+"-"+sjZjcsxx.getZjbysx():sjZjcsxx.getZjby());
            sjSggyZjzhcs1.setZjpl(StringUtils.isNotEmpty(sjZjcsxx.getZjplsx() )?sjZjcsxx.getZjpl()+"-"+sjZjcsxx.getZjplsx() :sjZjcsxx.getZjpl());
            sjSggyZjzhcsMapper.updateSjSggyZjzhcs(sjSggyZjzhcs1);
        }else {
            sjSggyZjzhcs1=new SjSggyZjzhcs();
            sjSggyZjzhcs1.setJh(sjZjcsxx.getJh());
            sjSggyZjzhcs1.setKc(sjZjcsxx.getKc());
            sjSggyZjzhcs1.setJd(jd);
            sjSggyZjzhcs1.setZtxh(sjZjcsxx.getZtxh());
            sjSggyZjzhcs1.setCc(sjZjcsxx.getCc());
            sjSggyZjzhcs1.setSy(sjZjcsxx.getSy());
            sjSggyZjzhcs1.setZjymd(sjZjcsxx.getZjymd());
            sjSggyZjzhcs1.setCj(sjZjcsxx.getCj());
            sjSggyZjzhcs1.setYj(sjZjcsxx.getYj());
            sjSggyZjzhcs1.setZjzy(StringUtils.isNotEmpty(sjZjcsxx.getZjzysx())?sjZjcsxx.getZjzy()+"-"+sjZjcsxx.getZjzysx():sjZjcsxx.getZjzy());
            sjSggyZjzhcs1.setZjzs(StringUtils.isNotEmpty(sjZjcsxx.getZjzssx())?sjZjcsxx.getZjzs()+"-"+sjZjcsxx.getZjzssx():sjZjcsxx.getZjzs());
            sjSggyZjzhcs1.setZjby(StringUtils.isNotEmpty(sjZjcsxx.getZjbysx())?sjZjcsxx.getZjby()+"-"+sjZjcsxx.getZjbysx():sjZjcsxx.getZjby());
            sjSggyZjzhcs1.setZjpl(StringUtils.isNotEmpty(sjZjcsxx.getZjplsx() )?sjZjcsxx.getZjpl()+"-"+sjZjcsxx.getZjplsx() :sjZjcsxx.getZjpl());
            sjSggyZjzhcsMapper.updateSjSggyZjzhcs(sjSggyZjzhcs1);
        }
        int i = sjZjcsxxMapper.updateSjZjcsxx(sjZjcsxx);
        return i;
    }

    /**
     * 批量删除设计-钻具参数信息
     * 
     * @param ids 需要删除的设计-钻具参数信息主键
     * @return 结果
     */
    @Override
    public int deleteSjZjcsxxByIds(Long[] ids)
    {
        return sjZjcsxxMapper.deleteSjZjcsxxByIds(ids);
    }

    /**
     * 删除设计-钻具参数信息信息
     * 
     * @param id 设计-钻具参数信息主键
     * @return 结果
     */
    @Override
    public int deleteSjZjcsxxById(Long id)
    {
        return sjZjcsxxMapper.deleteSjZjcsxxById(id);
    }
}
