package com.zjsgfa.project.zt.service.impl;

import java.util.List;
import com.zjsgfa.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zt.mapper.LjZtzhdfMapper;
import com.zjsgfa.project.zt.domain.LjZtzhdf;
import com.zjsgfa.project.zt.service.ILjZtzhdfService;

/**
 * 钻头综合得分Service业务层处理
 * 
 * @author
 * @date 2025-06-29
 */
@Service
public class LjZtzhdfServiceImpl implements ILjZtzhdfService 
{
    @Autowired
    private LjZtzhdfMapper ljZtzhdfMapper;

    /**
     * 查询钻头综合得分
     * 
     * @param id 钻头综合得分主键
     * @return 钻头综合得分
     */
    @Override
    public LjZtzhdf selectLjZtzhdfById(Long id)
    {
        return ljZtzhdfMapper.selectLjZtzhdfById(id);
    }

    /**
     * 查询钻头综合得分列表
     * 
     * @param ljZtzhdf 钻头综合得分
     * @return 钻头综合得分
     */
    @Override
    public List<LjZtzhdf> selectLjZtzhdfList(LjZtzhdf ljZtzhdf)
    {
        return ljZtzhdfMapper.selectLjZtzhdfList(ljZtzhdf);
    }

    /**
     * 新增钻头综合得分
     * 
     * @param ljZtzhdf 钻头综合得分
     * @return 结果
     */
    @Override
    public int insertLjZtzhdf(LjZtzhdf ljZtzhdf)
    {
        return ljZtzhdfMapper.insertLjZtzhdf(ljZtzhdf);
    }

    /**
     * 修改钻头综合得分
     * 
     * @param ljZtzhdf 钻头综合得分
     * @return 结果
     */
    @Override
    public int updateLjZtzhdf(LjZtzhdf ljZtzhdf)
    {
        ljZtzhdf.setUpdateTime(DateUtils.getNowDate());
        return ljZtzhdfMapper.updateLjZtzhdf(ljZtzhdf);
    }

    /**
     * 批量删除钻头综合得分
     * 
     * @param ids 需要删除的钻头综合得分主键
     * @return 结果
     */
    @Override
    public int deleteLjZtzhdfByIds(Long[] ids)
    {
        return ljZtzhdfMapper.deleteLjZtzhdfByIds(ids);
    }

    /**
     * 删除钻头综合得分信息
     * 
     * @param id 钻头综合得分主键
     * @return 结果
     */
    @Override
    public int deleteLjZtzhdfById(Long id)
    {
        return ljZtzhdfMapper.deleteLjZtzhdfById(id);
    }
}
