package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.TsyxclxxMapper;
import com.zjsgfa.project.zjsgfa.domain.Tsyxclxx;
import com.zjsgfa.project.zjsgfa.service.ITsyxclxxService;

/**
 * 特殊岩性常量信息Service业务层处理
 * 
 * @author
 * @date 2025-07-08
 */
@Service
public class TsyxclxxServiceImpl implements ITsyxclxxService 
{
    @Autowired
    private TsyxclxxMapper tsyxclxxMapper;

    /**
     * 查询特殊岩性常量信息
     * 
     * @param id 特殊岩性常量信息主键
     * @return 特殊岩性常量信息
     */
    @Override
    public Tsyxclxx selectTsyxclxxById(Long id)
    {
        return tsyxclxxMapper.selectTsyxclxxById(id);
    }

    /**
     * 查询特殊岩性常量信息列表
     * 
     * @param tsyxclxx 特殊岩性常量信息
     * @return 特殊岩性常量信息
     */
    @Override
    public List<Tsyxclxx> selectTsyxclxxList(Tsyxclxx tsyxclxx)
    {
        return tsyxclxxMapper.selectTsyxclxxList(tsyxclxx);
    }

    /**
     * 新增特殊岩性常量信息
     * 
     * @param tsyxclxx 特殊岩性常量信息
     * @return 结果
     */
    @Override
    public int insertTsyxclxx(Tsyxclxx tsyxclxx)
    {
        return tsyxclxxMapper.insertTsyxclxx(tsyxclxx);
    }

    /**
     * 修改特殊岩性常量信息
     * 
     * @param tsyxclxx 特殊岩性常量信息
     * @return 结果
     */
    @Override
    public int updateTsyxclxx(Tsyxclxx tsyxclxx)
    {
        return tsyxclxxMapper.updateTsyxclxx(tsyxclxx);
    }

    /**
     * 批量删除特殊岩性常量信息
     * 
     * @param ids 需要删除的特殊岩性常量信息主键
     * @return 结果
     */
    @Override
    public int deleteTsyxclxxByIds(Long[] ids)
    {
        return tsyxclxxMapper.deleteTsyxclxxByIds(ids);
    }

    /**
     * 删除特殊岩性常量信息信息
     * 
     * @param id 特殊岩性常量信息主键
     * @return 结果
     */
    @Override
    public int deleteTsyxclxxById(Long id)
    {
        return tsyxclxxMapper.deleteTsyxclxxById(id);
    }
}
