package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.ClYxsj;
import com.zjsgfa.project.zjsgfa.service.IClYxsjService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 常量-岩性数据Controller
 * 
 * @author ruoyi
 * @date 2025-09-22
 */
@RestController
@RequestMapping("/system/clYxsj")
public class ClYxsjController extends BaseController
{
    @Autowired
    private IClYxsjService clYxsjService;

    /**
     * 查询常量-岩性数据列表
     */
    @PreAuthorize("@ss.hasPermi('system:clYxsj:list')")
    @GetMapping("/list")
    public TableDataInfo list(ClYxsj clYxsj)
    {
        startPage();
        List<ClYxsj> list = clYxsjService.selectClYxsjList(clYxsj);
        return getDataTable(list);
    }

    /**
     * 导出常量-岩性数据列表
     */
    @PreAuthorize("@ss.hasPermi('system:clYxsj:export')")
    @Log(title = "常量-岩性数据", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ClYxsj clYxsj)
    {
        List<ClYxsj> list = clYxsjService.selectClYxsjList(clYxsj);
        ExcelUtil<ClYxsj> util = new ExcelUtil<ClYxsj>(ClYxsj.class);
        util.exportExcel(response, list, "常量-岩性数据数据");
    }

    /**
     * 获取常量-岩性数据详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:clYxsj:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(clYxsjService.selectClYxsjById(id));
    }

    /**
     * 新增常量-岩性数据
     */
    @PreAuthorize("@ss.hasPermi('system:clYxsj:add')")
    @Log(title = "常量-岩性数据", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ClYxsj clYxsj)
    {
        return toAjax(clYxsjService.insertClYxsj(clYxsj));
    }

    /**
     * 修改常量-岩性数据
     */
    @PreAuthorize("@ss.hasPermi('system:clYxsj:edit')")
    @Log(title = "常量-岩性数据", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ClYxsj clYxsj)
    {
        return toAjax(clYxsjService.updateClYxsj(clYxsj));
    }

    /**
     * 删除常量-岩性数据
     */
    @PreAuthorize("@ss.hasPermi('system:clYxsj:remove')")
    @Log(title = "常量-岩性数据", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(clYxsjService.deleteClYxsjByIds(ids));
    }
}
