package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 设计信息-邻井扫描对象 sj_ljsm
 * 
 * @author
 * @date 2025-07-22
 */
public class SjLjsm extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 井深（设计） */
    @Excel(name = "井深", readConverterExp = "设=计")
    private Double js;

    /** 垂深（设计） */
    @Excel(name = "垂深", readConverterExp = "设=计")
    private Double cs;

    /** 井号（比较井号） */
    @Excel(name = "井号", readConverterExp = "比=较井号")
    private String bjjh;

    /** 数据来源（比较井号） */
    @Excel(name = "数据来源", readConverterExp = "比=较井号")
    private String bjsjly;

    /** 井深（比较井号） */
    @Excel(name = "井深", readConverterExp = "比=较井号")
    private Double bjjs;

    /** 垂深（比较井号） */
    @Excel(name = "垂深", readConverterExp = "比=较井号")
    private Double bjcs;

    /** 最近距离（比较井号） */
    @Excel(name = "最近距离", readConverterExp = "比=较井号")
    private Double bjzjjl;

    /** 扫描角（比较井号） */
    @Excel(name = "扫描角", readConverterExp = "比=较井号")
    private Double bjsmj;

    /** 仰角（比较井号） */
    @Excel(name = "仰角", readConverterExp = "比=较井号")
    private Double bjyj;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setJh(String jh) 
    {
        this.jh = jh;
    }

    public String getJh() 
    {
        return jh;
    }

    public void setJs(Double js) 
    {
        this.js = js;
    }

    public Double getJs() 
    {
        return js;
    }

    public void setCs(Double cs) 
    {
        this.cs = cs;
    }

    public Double getCs() 
    {
        return cs;
    }

    public void setBjjh(String bjjh) 
    {
        this.bjjh = bjjh;
    }

    public String getBjjh() 
    {
        return bjjh;
    }

    public void setBjsjly(String bjsjly) 
    {
        this.bjsjly = bjsjly;
    }

    public String getBjsjly() 
    {
        return bjsjly;
    }

    public void setBjjs(Double bjjs) 
    {
        this.bjjs = bjjs;
    }

    public Double getBjjs() 
    {
        return bjjs;
    }

    public void setBjcs(Double bjcs) 
    {
        this.bjcs = bjcs;
    }

    public Double getBjcs() 
    {
        return bjcs;
    }

    public void setBjzjjl(Double bjzjjl) 
    {
        this.bjzjjl = bjzjjl;
    }

    public Double getBjzjjl() 
    {
        return bjzjjl;
    }

    public void setBjsmj(Double bjsmj) 
    {
        this.bjsmj = bjsmj;
    }

    public Double getBjsmj() 
    {
        return bjsmj;
    }

    public void setBjyj(Double bjyj) 
    {
        this.bjyj = bjyj;
    }

    public Double getBjyj() 
    {
        return bjyj;
    }

    public void setBz(String bz) 
    {
        this.bz = bz;
    }

    public String getBz() 
    {
        return bz;
    }

    public void setCreatedBy(String createdBy) 
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() 
    {
        return createdBy;
    }

    public void setCreatedTime(Date createdTime) 
    {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() 
    {
        return createdTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("jh", getJh())
            .append("js", getJs())
            .append("cs", getCs())
            .append("bjjh", getBjjh())
            .append("bjsjly", getBjsjly())
            .append("bjjs", getBjjs())
            .append("bjcs", getBjcs())
            .append("bjzjjl", getBjzjjl())
            .append("bjsmj", getBjsmj())
            .append("bjyj", getBjyj())
            .append("bz", getBz())
            .append("createdBy", getCreatedBy())
            .append("createdTime", getCreatedTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
