package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjZtcsxx;
import com.zjsgfa.project.zjsgfa.service.ISjZtcsxxService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计-钻头参数信息Controller
 * 
 * @author
 * @date 2025-08-18
 */
@RestController
@RequestMapping("/system/sjZtcsxx")
public class SjZtcsxxController extends BaseController
{
    @Autowired
    private ISjZtcsxxService sjZtcsxxService;

    /**
     * 查询设计-钻头参数信息列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZtcsxx:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjZtcsxx sjZtcsxx)
    {
        startPage();
        List<SjZtcsxx> list = sjZtcsxxService.selectSjZtcsxxList(sjZtcsxx);
        return getDataTable(list);
    }

    /**
     * 导出设计-钻头参数信息列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZtcsxx:export')")
    @Log(title = "设计-钻头参数信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjZtcsxx sjZtcsxx)
    {
        List<SjZtcsxx> list = sjZtcsxxService.selectSjZtcsxxList(sjZtcsxx);
        ExcelUtil<SjZtcsxx> util = new ExcelUtil<SjZtcsxx>(SjZtcsxx.class);
        util.exportExcel(response, list, "设计-钻头参数信息数据");
    }

    /**
     * 获取设计-钻头参数信息详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZtcsxx:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjZtcsxxService.selectSjZtcsxxById(id));
    }

    /**
     * 新增设计-钻头参数信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZtcsxx:add')")
    @Log(title = "设计-钻头参数信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjZtcsxx sjZtcsxx)
    {
        return toAjax(sjZtcsxxService.insertSjZtcsxx(sjZtcsxx));
    }

    /**
     * 修改设计-钻头参数信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZtcsxx:edit')")
    @Log(title = "设计-钻头参数信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjZtcsxx sjZtcsxx)
    {
        return toAjax(sjZtcsxxService.updateSjZtcsxx(sjZtcsxx));
    }

    /**
     * 删除设计-钻头参数信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZtcsxx:remove')")
    @Log(title = "设计-钻头参数信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjZtcsxxService.deleteSjZtcsxxByIds(ids));
    }
}
