package com.zjsgfa.project.zjsgfa.util;

import com.alibaba.fastjson2.JSONObject;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InfoExtractor {

    /**
     * 提取句子中的井号、钻井队、区块信息
     * @param sentence 待提取的原始句子
     * @return 封装好的JSON对象（包含jh/zjdmc/qk字段）
     */
    public static JSONObject extractInfo(String sentence) {
        JSONObject result = new JSONObject();

        // 1. 提取井号（匹配“梁+数字-斜+数字”格式，后接“井”字）
//        Pattern jhPattern = Pattern.compile("(梁\\d+-斜\\d+)井");
//        Pattern jhPattern = Pattern.compile("(梁|滨|桩|义)\\d+-斜\\d+井?");
//        Matcher jhMatcher = jhPattern.matcher(sentence);

        Pattern wellPattern = Pattern.compile("(桩斜\\d+-(?:斜)?\\d+|(?:梁|滨|桩|义)\\d+-斜\\d+)");
        Matcher jhMatcher = wellPattern.matcher(sentence);
        if (jhMatcher.find()) {
            result.put("jh", jhMatcher.group(1).replace("井", ""));
        } else {
            result.put("jh", ""); // 无匹配时返回空字符串
        }

        // 2. 提取钻井队名称（匹配“钻井队：”后到逗号/空格前的内容）
        Pattern zjdPattern = Pattern.compile("钻井队：([^，\\s]+)");
        Matcher zjdMatcher = zjdPattern.matcher(sentence);
        if (zjdMatcher.find()) {
            result.put("zjdmc", zjdMatcher.group(1));
        } else {
            result.put("zjdmc", "");
        }

        // 3. 提取区块名称（匹配“区块名称：”后到逗号/空格前的内容）
        Pattern qkPattern = Pattern.compile("区块名称：([^，\\s]+)");
        Matcher qkMatcher = qkPattern.matcher(sentence);
        if (qkMatcher.find()) {
            result.put("qk", qkMatcher.group(1));
        } else {
            result.put("qk", "");
        }

        return result;
    }

    public static void main(String[] args) {
        String text = "编制梁217-斜52井的施工方案，钻井队：井队，区块名称：小营，上传的地质设计和工程设计文档。\n" +
                "编制滨16-斜27井的施工方案，钻井队：井队，区块名称：小营，上传的地质设计和工程设计文档。\n" +
                "编制滨648-斜71的施工方案，钻井队：井队，区块名称：小营，上传的地质设计和工程设计文档。\n" +
                "编制桩80-斜4井的施工方案，钻井队：井队，区块名称：小营，上传的地质设计和工程设计文档。\n" +
                "编制桩斜80-斜4井的施工方案，钻井队：井队，区块名称：小营，上传的地质设计和工程设计文档。\n" +
                "编制桩斜80-4井的施工方案，钻井队：井队，区块名称：小营，上传的地质设计和工程设计文档。\n" +
                "编制义34-斜236井的施工方案，钻井队：井队，区块名称：小营，上传的地质设计和工程设计文档。";

        String text2 = "编制桩斜80-4井的施工方案，钻井队：井队，区块名称：小营，上传的地质设计和工程设计文档。";
        // 优化后正则：限定前缀为梁/滨/桩/义，排除“编制”
//        Pattern wellPattern = Pattern.compile("(桩斜\\\\d+-(?:斜)?\\\\d+|(?:梁|滨|桩|义)\\\\d+-斜\\\\d+)");
//
//        Matcher matcher = wellPattern.matcher(text);

        Pattern wellPattern = Pattern.compile("(桩斜\\d+-(?:斜)?\\d+|(?:梁|滨|桩|义)\\d+-斜\\d+)");
        Matcher matcher = wellPattern.matcher(text);
        List<String> wellNames = new ArrayList<>();
        while (matcher.find()) {
            String wellName = matcher.group(1).replace("井", ""); // 移除可能存在的"井"字
            wellNames.add(wellName);
        }

//        List<String> wellNames = new ArrayList<>();
//        while (matcher.find()) {
//            // 提取匹配结果（自动过滤“编制”）
//            wellNames.add(matcher.group(1)); // 提取核心井名（不含“井”字）
//        }

        System.out.println("提取的井名列表：");
        for (String wellName : wellNames) {
            // 若结果包含“井”字，可通过replace("井", "")去除
            System.out.println(wellName);
        }
    }
}