package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import com.zjsgfa.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SgfambKcxxMapper;
import com.zjsgfa.project.zjsgfa.domain.SgfambKcxx;
import com.zjsgfa.project.zjsgfa.service.ISgfambKcxxService;

/**
 * 施工方案模板管理—开次信息Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-09-23
 */
@Service
public class SgfambKcxxServiceImpl implements ISgfambKcxxService 
{
    @Autowired
    private SgfambKcxxMapper sgfambKcxxMapper;

    /**
     * 查询施工方案模板管理—开次信息
     * 
     * @param id 施工方案模板管理—开次信息主键
     * @return 施工方案模板管理—开次信息
     */
    @Override
    public SgfambKcxx selectSgfambKcxxById(Long id)
    {
        return sgfambKcxxMapper.selectSgfambKcxxById(id);
    }

    /**
     * 查询施工方案模板管理—开次信息列表
     * 
     * @param sgfambKcxx 施工方案模板管理—开次信息
     * @return 施工方案模板管理—开次信息
     */
    @Override
    public List<SgfambKcxx> selectSgfambKcxxList(SgfambKcxx sgfambKcxx)
    {
        return sgfambKcxxMapper.selectSgfambKcxxList(sgfambKcxx);
    }

    /**
     * 新增施工方案模板管理—开次信息
     * 
     * @param sgfambKcxx 施工方案模板管理—开次信息
     * @return 结果
     */
    @Override
    public int insertSgfambKcxx(SgfambKcxx sgfambKcxx)
    {
        return sgfambKcxxMapper.insertSgfambKcxx(sgfambKcxx);
    }

    /**
     * 修改施工方案模板管理—开次信息
     * 
     * @param sgfambKcxx 施工方案模板管理—开次信息
     * @return 结果
     */
    @Override
    public int updateSgfambKcxx(SgfambKcxx sgfambKcxx)
    {
        sgfambKcxx.setUpdateTime(DateUtils.getNowDate());
        return sgfambKcxxMapper.updateSgfambKcxx(sgfambKcxx);
    }

    /**
     * 批量删除施工方案模板管理—开次信息
     * 
     * @param ids 需要删除的施工方案模板管理—开次信息主键
     * @return 结果
     */
    @Override
    public int deleteSgfambKcxxByIds(Long[] ids)
    {
        return sgfambKcxxMapper.deleteSgfambKcxxByIds(ids);
    }

    /**
     * 删除施工方案模板管理—开次信息信息
     * 
     * @param id 施工方案模板管理—开次信息主键
     * @return 结果
     */
    @Override
    public int deleteSgfambKcxxById(Long id)
    {
        return sgfambKcxxMapper.deleteSgfambKcxxById(id);
    }
}
