package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;

import com.zjsgfa.common.exception.job.TaskException;
import com.zjsgfa.common.utils.DateUtils;
import com.zjsgfa.project.monitor.domain.SysJob;
import com.zjsgfa.project.monitor.service.ISysJobService;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.MxfxjgbMapper;
import com.zjsgfa.project.zjsgfa.domain.Mxfxjgb;
import com.zjsgfa.project.zjsgfa.service.IMxfxjgbService;
import org.springframework.transaction.annotation.Transactional;

/**
 * 大模型分析Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-10-22
 */
@Service
public class MxfxjgbServiceImpl implements IMxfxjgbService 
{
    @Autowired
    private MxfxjgbMapper mxfxjgbMapper;

    @Autowired
    private ISysJobService jobService;

    /**
     * 查询大模型分析
     * 
     * @param id 大模型分析主键
     * @return 大模型分析
     */
    @Override
    public Mxfxjgb selectMxfxjgbById(Long id)
    {
        return mxfxjgbMapper.selectMxfxjgbById(id);
    }

    /**
     * 查询大模型分析列表
     * 
     * @param mxfxjgb 大模型分析
     * @return 大模型分析
     */
    @Override
    public List<Mxfxjgb> selectMxfxjgbList(Mxfxjgb mxfxjgb)
    {
        return mxfxjgbMapper.selectMxfxjgbList(mxfxjgb);
    }

    /**
     * 新增大模型分析
     * 
     * @param mxfxjgb 大模型分析
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int insertMxfxjgb(Mxfxjgb mxfxjgb) throws SchedulerException, TaskException {
        int i = mxfxjgbMapper.insertMxfxjgb(mxfxjgb);
        if (i > 0) {
            SysJob sysJob =new SysJob();
            sysJob.setJobName(mxfxjgb.getRwmc());
            sysJob.setJobGroup("DEFAULT");
            sysJob.setInvokeTarget("mxdyTask.ryParams("+mxfxjgb.getId()+"L)");
            sysJob.setCronExpression("0 0 * * * ?");
            sysJob.setMisfirePolicy("2");
            sysJob.setConcurrent("0");
            sysJob.setStatus("0");
            jobService.insertJob(sysJob);
            mxfxjgb.setJobid(sysJob.getJobId());
            mxfxjgbMapper.updateMxfxjgb(mxfxjgb);
        }
        return i;
    }

    /**
     * 修改大模型分析
     * 
     * @param mxfxjgb 大模型分析
     * @return 结果
     */
    @Override
    public int updateMxfxjgb(Mxfxjgb mxfxjgb)
    {

        mxfxjgb.setUpdateTime(DateUtils.getNowDate());
        return mxfxjgbMapper.updateMxfxjgb(mxfxjgb);
    }

    /**
     * 批量删除大模型分析
     * 
     * @param ids 需要删除的大模型分析主键
     * @return 结果
     */
    @Override
    public int deleteMxfxjgbByIds(Long[] ids)
    {
        return mxfxjgbMapper.deleteMxfxjgbByIds(ids);
    }

    /**
     * 删除大模型分析信息
     * 
     * @param id 大模型分析主键
     * @return 结果
     */
    @Override
    public int deleteMxfxjgbById(Long id)
    {
        return mxfxjgbMapper.deleteMxfxjgbById(id);
    }

    @Override
    public int updateMxfxjgbByFaid(String faid) {
        return mxfxjgbMapper.updateMxfxjgbByFaid(faid);
    }
}
