package com.zjsgfa.project.zjsgfa.service;

import java.util.List;
import com.zjsgfa.project.zjsgfa.domain.CommonFile;

/**
 * 文件Service接口
 * 
 * @author ruoyi
 * @date 2025-10-27
 */
public interface ICommonFileService 
{
    /**
     * 查询文件
     * 
     * @param id 文件主键
     * @return 文件
     */
    public CommonFile selectCommonFileById(Long id);

    /**
     * 查询文件列表
     * 
     * @param commonFile 文件
     * @return 文件集合
     */
    public List<CommonFile> selectCommonFileList(CommonFile commonFile);

    /**
     * 新增文件
     * 
     * @param commonFile 文件
     * @return 结果
     */
    public int insertCommonFile(CommonFile commonFile);

    /**
     * 修改文件
     * 
     * @param commonFile 文件
     * @return 结果
     */
    public int updateCommonFile(CommonFile commonFile);

    /**
     * 批量删除文件
     * 
     * @param ids 需要删除的文件主键集合
     * @return 结果
     */
    public int deleteCommonFileByIds(Long[] ids);

    /**
     * 删除文件信息
     * 
     * @param id 文件主键
     * @return 结果
     */
    public int deleteCommonFileById(Long id);

    int deleteCommonFileByICommonFile(CommonFile upFile);
}
