package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 设计信息-邻井扫描对象 sj_ljsm
 * 
 * @author
 * @date 2025-07-22
 */
@Data
public class SjLjsm extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 井深（设计） */
    @Excel(name = "井深", readConverterExp = "设=计")
    private Double js;

    /** 垂深（设计） */
    @Excel(name = "垂深", readConverterExp = "设=计")
    private Double cs;

    /** 井号（比较井号） */
    @Excel(name = "井号", readConverterExp = "比较井号")
    private String bjjh;

    /** 数据来源（比较井号） */
    @Excel(name = "数据来源", readConverterExp = "比较井号")
    private String bjsjly;

    /** 井深（比较井号） */
    @Excel(name = "井深", readConverterExp = "比较井号")
    private Double bjjs;

    /** 垂深（比较井号） */
    @Excel(name = "垂深", readConverterExp = "比较井号")
    private Double bjcs;

    /** 最近距离（比较井号） */
    @Excel(name = "最近距离", readConverterExp = "比较井号")
    private Double bjzjjl;

    /** 扫描角（比较井号） */
    @Excel(name = "扫描角", readConverterExp = "比较井号")
    private Double bjsmj;

    /** 仰角（比较井号） */
    @Excel(name = "仰角", readConverterExp = "比较井号")
    private Double bjyj;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

}
