package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.Sgfamb;
import com.zjsgfa.project.zjsgfa.service.ISgfambService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 施工方案模板管理Controller
 * 
 * @author ruoyi
 * @date 2025-09-23
 */
@RestController
@RequestMapping("/system/sgfamb")
public class SgfambController extends BaseController
{
    @Autowired
    private ISgfambService sgfambService;

    /**
     * 查询施工方案模板管理列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sgfamb:list')")
    @GetMapping("/list")
    public TableDataInfo list(Sgfamb sgfamb)
    {
        startPage();
        List<Sgfamb> list = sgfambService.selectSgfambList(sgfamb);
        return getDataTable(list);
    }

    @GetMapping("/selectList")
    public TableDataInfo getList(Sgfamb sgfamb)
    {
//        startPage();
        List<Sgfamb> list = sgfambService.selectSgfambList(sgfamb);
        return getDataTable(list);
    }

    /**
     * 导出施工方案模板管理列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sgfamb:export')")
    @Log(title = "施工方案模板管理", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, Sgfamb sgfamb)
    {
        List<Sgfamb> list = sgfambService.selectSgfambList(sgfamb);
        ExcelUtil<Sgfamb> util = new ExcelUtil<Sgfamb>(Sgfamb.class);
        util.exportExcel(response, list, "施工方案模板管理数据");
    }

    /**
     * 获取施工方案模板管理详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sgfamb:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sgfambService.selectSgfambById(id));
    }

    /**
     * 新增施工方案模板管理
     */
    //@PreAuthorize("@ss.hasPermi('system:sgfamb:add')")
    @Log(title = "施工方案模板管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody Sgfamb sgfamb)
    {
        return toAjax(sgfambService.insertSgfamb(sgfamb));
    }

    /**
     * 修改施工方案模板管理
     */
    //@PreAuthorize("@ss.hasPermi('system:sgfamb:edit')")
    @Log(title = "施工方案模板管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody Sgfamb sgfamb)
    {
        return toAjax(sgfambService.updateSgfamb(sgfamb));
    }

    /**
     * 删除施工方案模板管理
     */
    //@PreAuthorize("@ss.hasPermi('system:sgfamb:remove')")
    @Log(title = "施工方案模板管理", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sgfambService.deleteSgfambByIds(ids));
    }
}
