package com.ruoyi.project.zt.service.impl;

import com.ruoyi.framework.aspectj.lang.annotation.DataSource;
import com.ruoyi.framework.aspectj.lang.enums.DataSourceType;
import com.ruoyi.project.zt.domain.Jsaa;
import com.ruoyi.project.zt.mapper.JsaaMapper;
import com.ruoyi.project.zt.service.IJsaaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 基础数据Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-07-10
 */
@Service
public class JsaaServiceImpl implements IJsaaService 
{
    @Autowired
    private JsaaMapper jsaaMapper;

    /**
     * 查询基础数据
     * 
     * @param jh 基础数据主键
     * @return 基础数据
     */
    @Override
    public Jsaa selectJsaaByJh(String jh)
    {
        return jsaaMapper.selectJsaaByJh(jh);
    }

    /**
     * 查询基础数据列表
     * 
     * @param jsaa 基础数据
     * @return 基础数据
     */
    @Override
    @DataSource(value = DataSourceType.SLAVE)
    public List<Jsaa> selectJsaaList(Jsaa jsaa)
    {
        return jsaaMapper.selectJsaaList(jsaa);
    }

    /**
     * 新增基础数据
     * 
     * @param jsaa 基础数据
     * @return 结果
     */
    @Override
    public int insertJsaa(Jsaa jsaa)
    {
        return jsaaMapper.insertJsaa(jsaa);
    }

    /**
     * 修改基础数据
     * 
     * @param jsaa 基础数据
     * @return 结果
     */
    @Override
    public int updateJsaa(Jsaa jsaa)
    {
        return jsaaMapper.updateJsaa(jsaa);
    }

    /**
     * 批量删除基础数据
     * @param jhs 需要删除的基础数据主键
     * @return 结果
     */
    @Override
    public int deleteJsaaByJhs(String[] jhs)
    {
        return jsaaMapper.deleteJsaaByJhs(jhs);
    }

    /**
     * 删除基础数据信息
     * 
     * @param jh 基础数据主键
     * @return 结果
     */
    @Override
    public int deleteJsaaByJh(String jh)
    {
        return jsaaMapper.deleteJsaaByJh(jh);
    }

    @Override
    public List<Jsaa> selectQklist(Jsaa jsaa) {
        return jsaaMapper.selectQklist(jsaa);
    }
}
