package com.ruoyi.project.zjsgfa.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.zjsgfa.mapper.SjH2sMapper;
import com.ruoyi.project.zjsgfa.domain.SjH2s;
import com.ruoyi.project.zjsgfa.service.ISjH2sService;

/**
 * 设计信息-H2SService业务层处理
 * 
 * @author ruoyi
 * @date 2025-07-22
 */
@Service
public class SjH2sServiceImpl implements ISjH2sService 
{
    @Autowired
    private SjH2sMapper sjH2sMapper;

    /**
     * 查询设计信息-H2S
     * 
     * @param id 设计信息-H2S主键
     * @return 设计信息-H2S
     */
    @Override
    public SjH2s selectSjH2sById(Long id)
    {
        return sjH2sMapper.selectSjH2sById(id);
    }

    /**
     * 查询设计信息-H2S列表
     * 
     * @param sjH2s 设计信息-H2S
     * @return 设计信息-H2S
     */
    @Override
    public List<SjH2s> selectSjH2sList(SjH2s sjH2s)
    {
        return sjH2sMapper.selectSjH2sList(sjH2s);
    }

    /**
     * 新增设计信息-H2S
     * 
     * @param sjH2s 设计信息-H2S
     * @return 结果
     */
    @Override
    public int insertSjH2s(SjH2s sjH2s)
    {
        return sjH2sMapper.insertSjH2s(sjH2s);
    }

    /**
     * 修改设计信息-H2S
     * 
     * @param sjH2s 设计信息-H2S
     * @return 结果
     */
    @Override
    public int updateSjH2s(SjH2s sjH2s)
    {
        sjH2s.setUpdateTime(DateUtils.getNowDate());
        return sjH2sMapper.updateSjH2s(sjH2s);
    }

    /**
     * 批量删除设计信息-H2S
     * 
     * @param ids 需要删除的设计信息-H2S主键
     * @return 结果
     */
    @Override
    public int deleteSjH2sByIds(Long[] ids)
    {
        return sjH2sMapper.deleteSjH2sByIds(ids);
    }

    /**
     * 删除设计信息-H2S信息
     * 
     * @param id 设计信息-H2S主键
     * @return 结果
     */
    @Override
    public int deleteSjH2sById(Long id)
    {
        return sjH2sMapper.deleteSjH2sById(id);
    }
}
