package com.ruoyi.project.zjsgfa.mapper;

import java.util.List;

import com.ruoyi.framework.aspectj.lang.annotation.DataSource;
import com.ruoyi.framework.aspectj.lang.enums.DataSourceType;
import com.ruoyi.project.zjsgfa.domain.SjDzfc;

/**
 * 地质分层Mapper接口
 * 
 * @author ruoyi
 * @date 2025-07-07
 */
@DataSource(value = DataSourceType.MASTER)
public interface SjDzfcMapper 
{
    /**
     * 查询地质分层
     * 
     * @param id 地质分层主键
     * @return 地质分层
     */
    public SjDzfc selectSjDzfcById(Long id);

    /**
     * 查询地质分层列表
     * 
     * @param sjDzfc 地质分层
     * @return 地质分层集合
     */
    public List<SjDzfc> selectSjDzfcList(SjDzfc sjDzfc);

    /**
     * 新增地质分层
     * 
     * @param sjDzfc 地质分层
     * @return 结果
     */
    public int insertSjDzfc(SjDzfc sjDzfc);

    /**
     * 修改地质分层
     * 
     * @param sjDzfc 地质分层
     * @return 结果
     */
    public int updateSjDzfc(SjDzfc sjDzfc);

    /**
     * 删除地质分层
     * 
     * @param id 地质分层主键
     * @return 结果
     */
    public int deleteSjDzfcById(Long id);

    /**
     * 批量删除地质分层
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSjDzfcByIds(Long[] ids);

    int deleteSjDzfcByJh(String jh);

    int insertSjDzfcBatch(List<SjDzfc> sjDzfcList);

}
