package com.ruoyi.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.zjsgfa.domain.SjZjyFdsj;
import com.ruoyi.project.zjsgfa.service.ISjZjyFdsjService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 设计信息-分段钻井液设计Controller
 * 
 * @author ruoyi
 * @date 2025-07-17
 */
@RestController
@RequestMapping("/system/sjZjyFdsj")
public class SjZjyFdsjController extends BaseController
{
    @Autowired
    private ISjZjyFdsjService sjZjyFdsjService;

    /**
     * 查询设计信息-分段钻井液设计列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZjyFdsj:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjZjyFdsj sjZjyFdsj)
    {
//        startPage();
        List<SjZjyFdsj> list = sjZjyFdsjService.selectSjZjyFdsjList(sjZjyFdsj);
        return getDataTable(list);
    }

    /**
     * 导出设计信息-分段钻井液设计列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZjyFdsj:export')")
    @Log(title = "设计信息-分段钻井液设计", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjZjyFdsj sjZjyFdsj)
    {
        List<SjZjyFdsj> list = sjZjyFdsjService.selectSjZjyFdsjList(sjZjyFdsj);
        ExcelUtil<SjZjyFdsj> util = new ExcelUtil<SjZjyFdsj>(SjZjyFdsj.class);
        util.exportExcel(response, list, "设计信息-分段钻井液设计数据");
    }

    /**
     * 获取设计信息-分段钻井液设计详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZjyFdsj:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjZjyFdsjService.selectSjZjyFdsjById(id));
    }

    /**
     * 新增设计信息-分段钻井液设计
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZjyFdsj:add')")
    @Log(title = "设计信息-分段钻井液设计", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjZjyFdsj sjZjyFdsj)
    {
        return toAjax(sjZjyFdsjService.insertSjZjyFdsj(sjZjyFdsj));
    }

    /**
     * 修改设计信息-分段钻井液设计
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZjyFdsj:edit')")
    @Log(title = "设计信息-分段钻井液设计", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjZjyFdsj sjZjyFdsj)
    {
        return toAjax(sjZjyFdsjService.updateSjZjyFdsj(sjZjyFdsj));
    }

    /**
     * 删除设计信息-分段钻井液设计
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZjyFdsj:remove')")
    @Log(title = "设计信息-分段钻井液设计", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjZjyFdsjService.deleteSjZjyFdsjByIds(ids));
    }
}
