package com.ruoyi.project.zjsgfa.mapper;

import java.util.List;
import com.ruoyi.project.zjsgfa.domain.SjFdsgcs;

/**
 * 设计-分段施工措施Mapper接口
 * 
 * @author ruoyi
 * @date 2025-08-06
 */
public interface SjFdsgcsMapper 
{
    /**
     * 查询设计-分段施工措施
     * 
     * @param id 设计-分段施工措施主键
     * @return 设计-分段施工措施
     */
    public SjFdsgcs selectSjFdsgcsById(Long id);

    /**
     * 查询设计-分段施工措施列表
     * 
     * @param sjFdsgcs 设计-分段施工措施
     * @return 设计-分段施工措施集合
     */
    public List<SjFdsgcs> selectSjFdsgcsList(SjFdsgcs sjFdsgcs);

    /**
     * 新增设计-分段施工措施
     * 
     * @param sjFdsgcs 设计-分段施工措施
     * @return 结果
     */
    public int insertSjFdsgcs(SjFdsgcs sjFdsgcs);

    /**
     * 修改设计-分段施工措施
     * 
     * @param sjFdsgcs 设计-分段施工措施
     * @return 结果
     */
    public int updateSjFdsgcs(SjFdsgcs sjFdsgcs);

    /**
     * 删除设计-分段施工措施
     * 
     * @param id 设计-分段施工措施主键
     * @return 结果
     */
    public int deleteSjFdsgcsById(Long id);

    /**
     * 批量删除设计-分段施工措施
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSjFdsgcsByIds(Long[] ids);

    SjFdsgcs selectSjFdsgcsByJhAndKc(SjFdsgcs sjFdsgcs);


}
